<?php

namespace App\Infrastructure\Bridge\Preferential\Cmd;

use App\Infrastructure\Bridge\Preferential\VO\GiftCardOrderVO;

/**
 * 礼品卡订单传输对象
 * Class GiftCardOrderCmd
 * @package App\Infrastructure\Bridge\Preferential\Cmd
 */
class GiftCardOrderCmd {

    /** @var string 卡类型 */
    public string $type;

    /** @var string 手机号 */
    public string $phone;

    /** @var int 用户ID */
    public int $userId;

    /** @var string 支付类型 */
    public string $payType;

    /** @var int 门店ID */
    public int $storeId;

    /** @var string 用户名称 */
    public string $userName;

    /** @var string 原金额 */
    public string $oriMoney;

    /** @var string 实付金额 */
    public string $payMoney;

    /** @var int 创建人 */
    public int $createBy;

    /** @var string 购买渠道 */
    public string $buyChannel;

    /** @var GiftCardOrderVO */
    public GiftCardOrderVO $extend;

    public function toGiftCardOrderFormat () {
        return [
            'type'        => $this->type,
            'phone'       => $this->phone,
            'user_id'     => $this->userId,
            'pay_type'    => $this->payType,
            'buy_channel' => $this->buyChannel,
            'store_id'    => $this->storeId,
            'user_name'   => $this->userName,
            'ori_money'   => $this->oriMoney,
            'pay_money'   => $this->payMoney,
            'create_by'   => $this->createBy,
            'extend'      => [
                'count'       => $this->extend->count,
                'cover_id'    => $this->extend->coverId,
                'money'       => $this->extend->money,
                'stop_usage'  => $this->extend->stopUsage,
                'start_usage' => $this->extend->startUsage,
                'title'       => $this->extend->title,
            ],
        ];
    }

}