<?php


namespace App\Infrastructure\Bridge\DingDing;


use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use App\Infrastructure\Bridge\DingDing\Setting\DingDingSetting;

/**
 * 钉钉通知服务
 * Class DingDingNoticeService
 * @package App\Infrastructure\Bridge\DingDing
 */
class DingDingNoticeService {

    /**
     * 请求钉钉通知
     * @param string $message
     * @param string $traceId
     * @return string
     * @throws GuzzleException
     */
    public static function sendDingDingErrorNotice (string $message, string $traceId): string {
        $client = new Client();
        $response = $client->request('POST', DingDingSetting::newInstance()->url, [
            'headers' => ['Content-Type' => 'application/json'],
            'json'    => [
                'msgtype'  => 'markdown',
                'markdown' => [
                    'title' => "第三方平台券码对接",
                    'text'  => "#### 大栗子发现\n + 平台：中国移动\n + 错误信息：{$message}\n + trace_id：".$traceId,
                ],
            ],
        ]);

        return $response->getBody()->getContents();
    }
}
