<?php


namespace App\Domain\ThirdPartyOrder\Translator;


use App\Domain\ThirdPartyOrder\Cmd\CMCCSignCmd;
use App\Domain\ThirdPartyOrder\Cmd\CMCCOpenRightCmd;
use App\Domain\ThirdPartyOrder\Enum\CMCCCodeEnum;
use App\Domain\ThirdPartyOrder\Cmd\CMCCOpenRightHeadCmd;
use App\Domain\ThirdPartyOrder\Enum\CMCCOpenRightCodeEnum;
use App\Domain\ThirdPartyOrder\Service\CMCCApiService;
use App\Domain\ThirdPartyOrder\Cmd\CMCCOpenCallbackCmd;
use App\Domain\ThirdPartyOrder\Cmd\CMCCOpenCallbackBodyCmd;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderEntity;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderItemEntity;
use App\Infrastructure\Bridge\CMCC\Setting\CMCCSetting;

class ThirdPartyOrderToCMCCCmd {

    /**
     * @param CMCCOpenRightCmd $orderCmd
     * @param ThirdPartyOrderEntity $orderEntity
     * @return CMCCOpenCallbackCmd
     */
    public function toCMCCOpenCallbackCmd (CMCCOpenRightCmd $orderCmd, ThirdPartyOrderEntity $orderEntity): CMCCOpenCallbackCmd {
        /** @var ThirdPartyOrderItemEntity $itemEntity */
        $itemEntity = $orderEntity->items->first();
        $coupon = app(CMCCApiService::class)->encryptCoupon($itemEntity->code);
        $bodyCmd = new CMCCOpenCallbackBodyCmd();
        $bodyCmd->coupon = $coupon;
        $bodyCmd->endTime = $orderEntity->stopUsage;
        $bodyCmd->msg = '开通成功';
        $bodyCmd->orderItemId = $orderEntity->thirdOrderId;
        $bodyCmd->rightsId = $orderCmd->contractRoot->body->rightsId;
        $bodyCmd->startTime = $orderEntity->startUsage;
        $bodyCmd->status = CMCCOpenRightCodeEnum::SUCCESS;

        // 签名
        $reqTime = date('YmdHis').'000';
        $sign = app(CMCCApiService::class)->makeSign(CMCCSignCmd::from($orderCmd->contractRoot->head->transactionId, $reqTime, $bodyCmd->toJson()), CMCCSetting::newInstance()->callbackPrivateKey, false);

        $headCmd = new CMCCOpenRightHeadCmd();
        $headCmd->sign = $sign;
        $headCmd->reqTime = $reqTime;
        $headCmd->apiId = CMCCSetting::newInstance()->callbackApiId;
        $headCmd->channelCode = $orderCmd->contractRoot->head->channelCode;
        $headCmd->transactionId = $orderCmd->contractRoot->head->transactionId;

        return CMCCOpenCallbackCmd::from($headCmd, $bodyCmd);
    }
}