<?php


namespace App\Domain\ThirdPartyOrder\Translator;


use Mainto\Bridge\Enums\Preferential\BuyChannelEnum;
use Mainto\Bridge\Enums\Preferential\OrderPayTypeEnum;
use Mainto\Bridge\Enums\Preferential\GiftCardOrderTypeEnum;
use App\Domain\ThirdPartyOrder\Setting\ThirdPartyOrderSetting;
use App\Infrastructure\Bridge\Preferential\VO\GiftCardOrderVO;
use App\Infrastructure\Bridge\Preferential\Cmd\GiftCardOrderCmd;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderEntity;

/***
 * Class CMCCToPreferentialCmd
 * @package App\Infrastructure\Bridge\CMCC\Translator
 */
class CMCCToPreferentialCmd {

    /**
     * @param ThirdPartyOrderEntity $orderEntity
     * @return GiftCardOrderCmd
     */
    public function toGiftCardOrderCmd (ThirdPartyOrderEntity $orderEntity): GiftCardOrderCmd {
        $giftCardOrderCmd = new GiftCardOrderCmd();
        $giftCardOrderCmd->type = GiftCardOrderTypeEnum::VIRTUAL;
        $giftCardOrderCmd->phone = $orderEntity->phone;
        $giftCardOrderCmd->userId = $orderEntity->userId;
        $giftCardOrderCmd->payType = OrderPayTypeEnum::CHINA_MOBIE;
        $giftCardOrderCmd->storeId = ThirdPartyOrderSetting::newInstance()->storeId;
        $giftCardOrderCmd->userName = $orderEntity->phone;
        $giftCardOrderCmd->oriMoney = $orderEntity->price;
        $giftCardOrderCmd->payMoney = $orderEntity->price;
        $giftCardOrderCmd->createBy = ThirdPartyOrderSetting::newInstance()->createBy;
        $giftCardOrderCmd->buyChannel = BuyChannelEnum::CHINA_MOBIE;
        $giftCardOrderCmd->extend = $this->toGiftCardOrderVO($orderEntity);

        return $giftCardOrderCmd;
    }

    /**
     * @param ThirdPartyOrderEntity $orderEntity
     * @return GiftCardOrderVO
     */
    private function toGiftCardOrderVO (ThirdPartyOrderEntity $orderEntity): GiftCardOrderVO {
        $orderVO = new GiftCardOrderVO();
        $orderVO->count = 1;
        $orderVO->title = '中国移动福利购买';
        $orderVO->coverId = ThirdPartyOrderSetting::newInstance()->coverId;
        $orderVO->money = $orderEntity->price;
        $orderVO->startUsage = $orderEntity->startUsage;
        $orderVO->stopUsage = $orderEntity->stopUsage;

        return $orderVO;
    }

}