<?php


namespace App\Domain\ThirdPartyOrder\Service;


use App\Domain\ThirdPartyOrder\Model\VO\GiftCardItemExtendVO;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderItemEntity;
use App\Domain\ThirdPartyOrder\Model\VO\ThirdPartyOrderIdVO;

/**
 * 工厂主要是实例化实体
 * Class ThirdPartyOrderFactory
 * @package App\Domain\ThirdPartyOrder\Service
 */
class ThirdPartyOrderFactory {

    /**
     * @param ThirdPartyOrderIdVO $orderIdVO
     * @param string $code
     * @param int $giftCardOrderId
     * @return ThirdPartyOrderItemEntity
     */
    public function newThirdPartyOrderItemEntity (ThirdPartyOrderIdVO $orderIdVO, string $code, int $giftCardOrderId): ThirdPartyOrderItemEntity {
        $orderItemEntity = new ThirdPartyOrderItemEntity();
        $orderItemEntity->code = $code;
        $orderItemEntity->thirdId = $orderIdVO;
        $orderItemEntity->extend = $this->newGiftCardItemExtendVO($giftCardOrderId);

        return $orderItemEntity;
    }

    /**
     * @param int $giftCardOrderId
     * @return GiftCardItemExtendVO
     */
    public function newGiftCardItemExtendVO (int $giftCardOrderId): GiftCardItemExtendVO {
        $giftCardItemExtendVO = new GiftCardItemExtendVO();
        $giftCardItemExtendVO->giftCardOrderId = $giftCardOrderId;

        return $giftCardItemExtendVO;
    }
}