<?php


namespace App\Domain\ThirdPartyOrder\Service;


use Mainto\RpcServer\RpcUtil\RpcMessage;
use App\Infrastructure\Bridge\CMCC\Setting\CMCCSetting;
use App\Domain\ThirdPartyOrder\Cmd\CMCCSignCmd;
use App\Domain\ThirdPartyOrder\Cmd\CMCCOpenRightCmd;
use App\Domain\ThirdPartyOrder\Exception\CMCCOrderException;
use App\Domain\ThirdPartyOrder\Messages\CMCCGenerateMessage;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderEntity;
use App\Domain\ThirdPartyOrder\Model\Repository\ThirdPartyOrderRepository;

class CMCCOrderService {

    /**
     * @param CMCCSignCmd $signCmd
     * @param CMCCOpenRightCmd $orderCmd
     * @return bool
     */
    public function openRight (CMCCSignCmd $signCmd, CMCCOpenRightCmd $orderCmd): bool {
        // 检测签名
        $signRes = app(CMCCApiService::class)->checkSign($signCmd, CMCCSetting::newInstance()->rightPrivateKey);
        if (!$signRes) {
            throw CMCCOrderException::SIGN_VALIDATE_FAIL();
        }

        // 发送 mq
        return $this->generateMessage($orderCmd);
    }

    /**
     * @param CMCCOpenRightCmd $orderCmd
     * @return bool
     */
    private function generateMessage (CMCCOpenRightCmd $orderCmd): bool {
        $generateMQ = new CMCCGenerateMessage();
        $generateMQ->contractRoot = $orderCmd->contractRoot;
        RpcMessage::getInstance()->sendDelayMessage(1000, $generateMQ);

        return true;
    }

    /**
     * @param ThirdPartyOrderEntity $orderEntity
     * @return bool
     * @throws \Throwable
     */
    public function openCallback (ThirdPartyOrderEntity $orderEntity): bool {
        // 保存实体
        app(ThirdPartyOrderRepository::class)->save($orderEntity);
        // 创建礼品卡
        $orderEntity->createGiftCard();

        return true;
    }
}