<?php


namespace App\Domain\ThirdPartyOrder\Model\VO;


use Mainto\DDDCore\Interfaces\Identity;
use Mainto\DDDCore\Interfaces\ValueObject;

class ThirdPartyOrderItemIdVO implements ValueObject, Identity {

    /** @var int 主健ID */
    private int $thirdPartyOrderItemId;

    /**
     * ThirdPartyOrderIdVO constructor.
     * @param int $thirdPartyOrderItemId
     */
    public function __construct (int $thirdPartyOrderItemId) {
        $this->thirdPartyOrderItemId = $thirdPartyOrderItemId;
    }

    public function value (): int {
        return $this->thirdPartyOrderItemId;
    }

    public function sameValueAs (ValueObject $other): bool {
        if ($other instanceof ThirdPartyOrderItemIdVO) {
            return $this->thirdPartyOrderItemId = $other->thirdPartyOrderItemId;
        }

        return false;
    }
}