<?php


namespace App\Domain\ThirdPartyOrder\Model\VO;


use Mainto\DDDCore\Interfaces\Identity;
use Mainto\DDDCore\Interfaces\ValueObject;

class ThirdPartyOrderIdVO implements ValueObject, Identity {

    /** @var int 主健ID */
    private int $thirdPartyOrderId;

    /**
     * ThirdPartyOrderIdVO constructor.
     * @param int $thirdPartyOrderId
     */
    public function __construct (int $thirdPartyOrderId) {
        $this->thirdPartyOrderId = $thirdPartyOrderId;
    }

    public function value (): int {
        return $this->thirdPartyOrderId;
    }

    public function sameValueAs (ValueObject $other): bool {
        if ($other instanceof ThirdPartyOrderIdVO) {
            return $this->thirdPartyOrderId = $other->thirdPartyOrderId;
        }

        return false;
    }
}