<?php


namespace App\Domain\ThirdPartyOrder\Model\VO;


use Mainto\DDDCore\Interfaces\ValueObject;

class CMCCOrderExtendVO implements ValueObject, ThirdPartyOrderExtendVO {

    /** @var string 权益方ID */
    public string $rightsId;

    /** @var string skuId */
    public string $skuId;

    /** @var string sku名称 */
    public string $skuName;

    /** @var string 创建时间 yyyyMMddHHmmssSSS */
    public string $createTime;

    public function sameValueAs (ValueObject $other): bool {
        return false;
    }

    public function toArray (): array {
        return get_object_vars($this);
    }
}