<?php


namespace App\Domain\ThirdPartyOrder\Model\Repository;


use Illuminate\Support\Collection;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderEntity;

interface ThirdPartyOrderRepository {

    /**
     * @param ThirdPartyOrderEntity $orderEntity
     * @return bool
     */
    public function save (ThirdPartyOrderEntity $orderEntity): bool;

    /**
     * @param ThirdPartyOrderEntity $orderEntity
     * @param Collection $thirdPartyOrderItemEntities
     * @return bool
     */
    public function createThirdPartyOrderCodes (ThirdPartyOrderEntity $orderEntity, Collection $thirdPartyOrderItemEntities): bool;

    /**
     * @param string $thirdOrderId
     * @param string $thirdType
     * @return int
     */
    public function getItemsCountByThirdTypeOrder (string $thirdOrderId, string $thirdType): int;
}