<?php


namespace App\Domain\ThirdPartyOrder\Model\Entity;


use Carbon\Carbon;
use Mainto\DDDCore\Interfaces\Entity;
use Mainto\DDDCore\Interfaces\Identity;
use App\Domain\ThirdPartyOrder\Model\VO\ThirdPartyOrderIdVO;
use App\Domain\ThirdPartyOrder\Model\VO\ThirdPartyOrderItemIdVO;
use App\Domain\ThirdPartyOrder\Model\VO\ThirdPartyOrderItemExtendVO;

/**
 * 第三方订单券码实体
 * Class ThirdPartyOrderItemEntity
 * @package App\Domain\ThirdPartyOrder\Model\Entity、
 */
class ThirdPartyOrderItemEntity implements Entity {

    /** @var ThirdPartyOrderItemIdVO|null  */
    public ?ThirdPartyOrderItemIdVO $orderItemIdVO;

    /** @var string code */
    public string $code;

    /** @var ThirdPartyOrderIdVO  */
    public ThirdPartyOrderIdVO $thirdId;

    /** @var Carbon|null */
    public ?Carbon $createdAt;

    /** @var Carbon|null */
    public ?Carbon $updatedAt;

    /** @var ThirdPartyOrderItemExtendVO 扩展信息 */
    public ThirdPartyOrderItemExtendVO $extend;

    public function sameIdentityAs (Entity $other): bool {
        if ($other instanceof ThirdPartyOrderItemEntity) {
            return $other->orderItemIdVO->sameValueAs($this->orderItemIdVO);
        }

        return false;
    }

    public function identity (): Identity {
        return $this->orderItemIdVO;
    }
}