<?php


namespace App\Domain\ThirdPartyOrder\Model\Entity;


use App\Infrastructure\Bridge\CMCC\DTO\GiftCardItemDTO;
use App\Infrastructure\Bridge\CMCC\DTO\GiftCardOrderDTO;
use Carbon\Carbon;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Mainto\DDDCore\Interfaces\Entity;
use Mainto\DDDCore\Interfaces\Identity;
use App\Infrastructure\Bridge\Preferential\GiftCardBridge;
use App\Domain\ThirdPartyOrder\Model\VO\ThirdPartyOrderIdVO;
use App\Domain\ThirdPartyOrder\Service\ThirdPartyOrderFactory;
use App\Domain\ThirdPartyOrder\Translator\CMCCToPreferentialCmd;
use App\Domain\ThirdPartyOrder\Model\VO\ThirdPartyOrderExtendVO;
use App\Domain\ThirdPartyOrder\Model\Repository\ThirdPartyOrderItemRepository;

/**
 * 第三方订单实体
 * Class ThirdPartyOrderEntity
 * @package App\Domain\ThirdPartyOrder\Model\Entity
 */
class ThirdPartyOrderEntity implements Entity {

    /** @var ThirdPartyOrderIdVO|null */
    public ?ThirdPartyOrderIdVO $orderIdVO;

    /** @var string 第三方订单ID */
    public string $thirdOrderId;

    /** @var string 第三方订单类型 */
    public string $thirdType;

    /** @var string 手机号 */
    public string $phone;

    /** @var string 价格 */
    public string $price;

    /** @var int 用户ID */
    public int $userId;

    /** @var int 购买数量 */
    public int $count;

    /** @var string sku id */
    public string $skuId;

    /** @var string 开始日期 */
    public string $startUsage;

    /** @var string 结束日期 */
    public string $stopUsage;

    /** @var Carbon|null */
    public ?Carbon $createdAt;

    /** @var Carbon|null */
    public ?Carbon $updatedAt;

    /** @var ThirdPartyOrderExtendVO 扩展信息 */
    public ThirdPartyOrderExtendVO $extend;

    /** @var Collection<ThirdPartyOrderItemEntity> $items */
    public Collection $items;

    public function sameIdentityAs (Entity $other): bool {
        if ($other instanceof ThirdPartyOrderEntity) {
            return $other->orderIdVO->sameValueAs($this->orderIdVO);
        }

        return false;
    }

    public function identity (): Identity {
        return $this->orderIdVO;
    }

    /**
     * @return bool
     */
    public function createGiftCard (): bool {
        // 制作券码
        $giftCardOrder = app(GiftCardBridge::class)->createGiftCard(app(CMCCToPreferentialCmd::class)->toGiftCardOrderCmd($this)->toGiftCardOrderFormat());
        $cardOrderDto = tap(new GiftCardOrderDTO(), function ($object) use ($giftCardOrder) {
            return app('json_mapper')->map($giftCardOrder, $object);
        });
        // 获取券码信息
        $giftCardOrderInfo = app(GiftCardBridge::class)->getCardsInfo($cardOrderDto->id);
        $giftCardOrderDto = tap(new GiftCardOrderDTO(), function ($object) use ($giftCardOrderInfo) {
            return app('json_mapper')->map($giftCardOrderInfo, $object);
        });
        // 绑定券码数据
        $this->items = collect($giftCardOrderDto->items)->map(
            fn(GiftCardItemDTO $itemDto) => app(ThirdPartyOrderFactory::class)->newThirdPartyOrderItemEntity($this->orderIdVO, $itemDto->card->code, $giftCardOrderDto->id)
        );
        // 保存数据
        app(ThirdPartyOrderItemRepository::class)->batchSave($this->items);

        return true;
    }
}