<?php


namespace App\Domain\ThirdPartyOrder\Enum;


use Mainto\RpcServer\Base\RpcEnum;
use Mainto\RpcServer\RpcAnnotations\Alias;

/**
 * @Alias(name="CMCC 结果码枚举值")
 * Class CMCCCodeEnum
 * @package App\Domain\ThirdPartyOrder\Enum
 */
class CMCCCodeEnum extends RpcEnum {

    /** @var string 受理成功 */
    const SUCCESS = '0000';

    /** @var string 受理失败 */
    const FAIL = '0001';

    /** @var string 签名错误 */
    const SIGN_ERROR = '0002';

    /** @var string 参数错误 */
    const PARAMS_ERROR = '0004';

    /** @var string 订单状态异常 */
    const ORDER_EXCEPTION = '1010';

    /** @var string 其他异常 */
    const OTHER_EXCEPTION = '9999';
}
