<?php


namespace App\Domain\ThirdPartyOrder\Cmd;

/**
 * Class CMCCSignCmd
 * @package App\Domain\ThirdPartyOrder\Cmd
 */
class CMCCSignCmd {

    /** @var string 渠道编码 */
    public string $channelCode;

    /** @var string 请求时间 yyyyMMddHHmmssSSS */
    public string $reqTime;

    /** @var string 数字签名 */
    public string $sign;

    /** @var string 业务编码(接口ID) */
    public string $apiId;

    /** @var string 请求流水号 */
    public string $transactionId;

    /** @var string 请求体 */
    public string $body;

    /**
     * @param string $transactionId
     * @param string $reqTime
     * @param string $body
     * @return CMCCSignCmd
     */
    public static function from (string $transactionId, string $reqTime, string $body): CMCCSignCmd {
        $cmd = new self();
        $cmd->transactionId = $transactionId;
        $cmd->reqTime = $reqTime;
        $cmd->body = $body;

        return $cmd;
    }
}