<?php


namespace App\Domain\ThirdPartyOrder\Cmd;


use App\Domain\ThirdPartyOrder\Enum\ThirdPartyTypeEnum;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderEntity;
use App\Domain\ThirdPartyOrder\Model\VO\CMCCOrderExtendVO;
use Carbon\Carbon;
use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class CMCCOpenRightCmd
 * @package App\Domain\ThirdPartyOrder\Cmd
 */
class CMCCOpenRightCmd extends RpcObject {

    /** @var CMCCOpenRightContractCmd 中国移动对接传递的参数 */
    public CMCCOpenRightContractCmd $contractRoot;

    /**
     * 拼接 CMCC 订单值对象
     * @return CMCCOrderExtendVO
     */
    private function toCMCCExtendVO (): CMCCOrderExtendVO {
        $CMCCExtendVO = new CMCCOrderExtendVO();
        $CMCCExtendVO->rightsId = $this->contractRoot->body->rightsId;
        $CMCCExtendVO->skuId = $this->contractRoot->body->skuId;
        $CMCCExtendVO->skuName = $this->contractRoot->body->skuName;
        $CMCCExtendVO->createTime = $this->contractRoot->body->createTime;

        return $CMCCExtendVO;
    }

    /**
     * 拼接实体
     * @param int $userId
     * @return ThirdPartyOrderEntity
     */
    public function toThirdPartyOrderEntity (int $userId): ThirdPartyOrderEntity {
        $now = now();
        $orderEntity = new ThirdPartyOrderEntity();
        $orderEntity->price = $this->contractRoot->body->price;
        $orderEntity->thirdOrderId = $this->contractRoot->body->orderItemId;
        $orderEntity->count = $this->contractRoot->body->quantity;
        $orderEntity->skuId = $this->contractRoot->body->skuCode;
        $orderEntity->thirdType = ThirdPartyTypeEnum::CMCC;
        $orderEntity->phone = $this->contractRoot->body->serverNum;
        $orderEntity->userId = $userId;
        $orderEntity->extend = $this->toCMCCExtendVO();
        $orderEntity->startUsage = $now->toDateTimeString();
        $orderEntity->stopUsage = Carbon::parse($now)->addYear()->toDateTimeString();

        return $orderEntity;
    }
}