<?php


namespace App\Domain\ThirdPartyOrder\Cmd;

/**
 * Class CMCCOpenCallbackCmd
 * @package App\Domain\ThirdPartyOrder\Cmd
 */
class CMCCOpenCallbackCmd {

    /** @var CMCCOpenCallbackContractCmd $contractRoot */
    public CMCCOpenCallbackContractCmd $contractRoot;

    /**
     * @param CMCCOpenRightHeadCmd $headCmd
     * @param CMCCOpenCallbackBodyCmd $bodyCmd
     * @return CMCCOpenCallbackCmd
     */
    public static function from (CMCCOpenRightHeadCmd $headCmd, CMCCOpenCallbackBodyCmd $bodyCmd): CMCCOpenCallbackCmd {
        $contractCmd = new CMCCOpenCallbackContractCmd();
        $contractCmd->headCmd = $headCmd;
        $contractCmd->bodyCmd = $bodyCmd;

        $cmd = new self();
        $cmd->contractRoot = $contractCmd;

        return $cmd;
    }

    /**
     * @return array
     */
    public function toArray (): array {
        return [
            'contractRoot' => [
                'body' => get_object_vars($this->contractRoot->bodyCmd),
                'head' => get_object_vars($this->contractRoot->headCmd),
            ]
        ];
    }
}