{{/* vim: set filetype=mustache: */}}
{{/*
Expand the name of the chart.
*/}}
{{- define "name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 24 | trimSuffix "-" -}}
{{- end -}}

{{- define "appname" -}}
{{- $releaseName := default .Release.Name .Values.releaseOverride -}}
{{- printf "%s" $releaseName | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{- define "trackableappname" -}}
{{- $trackableName := printf "%s-%s" (include "appname" .) .Values.application.track -}}
{{- $trackableName | trimSuffix "-stable" | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{/*
Get a hostname from URL
*/}}
{{- define "hostname" -}}
{{- . | trimPrefix "http://" |  trimPrefix "https://" | trimSuffix "/" | quote -}}
{{- end -}}
  
{{- define "servicename" -}}
{{- default .Chart.Name .Values.application.service_name }}
{{- end -}}
  
{{/*
Get redis host
*/}}
{{- define "redis_hostname" -}}
{{- if .Values.redis.enable -}}
{{- printf "%s-redis" (include "trackableappname" .) | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- printf "%s" (.Values.env.redis_host) -}}
{{- end -}}
{{- end -}}

{{/*
Get redis maxmemory size
*/}}
{{- define "redis_maxmemorysize" -}}
{{- if hasSuffix "Mi" .Values.redis.memory -}}
{{- printf "%d" (div (mul (trimSuffix "Mi" .Values.redis.memory) 1048576 4) 5) -}}
{{- else if hasSuffix "Gi" .Values.redis.memory -}}
{{- printf "%d" (div (mul (trimSuffix "Gi" .Values.redis.memory) 1073741824 4) 5) -}}
{{- else -}}
{{- fail "Size Error, Must Suffix Mi or Gi" -}}
{{- end -}}
{{- end -}}