# RPC模板项目说明

### 本项目为RPC-PHP端的模板项目，新增项目请从此项目克隆再推送到新项目

```
# 先新建空项目，获得 [new-project-name], [new-project-repository-address] (如 himo-test, https://code.hzmantu.com/mantu-tech/micro/himo-test)
git clone https://code.hzmantu.com/mantu-tech/micro/service-php-template.git [new-project-name]
cd [new-project-name]
git remote rename origin template
git remote add origin [new-project-repository-address]
git push -u origin dev

# 项目基础配置(新建分支更改)

1. 修改 .env.example 中的 RPC_SERVER_NAME -> 取一个服务名
2. 修改 chart/Chart.yaml 中的 name -> 项目路径名 (eg: himo-test)
3. 修改 chart/Chart.yaml 中的 description -> 项目简要描述
4. 修改 chart/values.yaml 中的 application.service_name -> 同 RPC_SERVER_NAME

# 跑ci需要放到Mainto Tech / Micro Service Backend
```

### 框架2.0更新说明 2020-08-21

#### 与 框架1.0 不同处

+ 2.0 框架包为 mainto/php-rpc-framework
+ php版本的最低依赖为 7.4
+ 1.0的 mainto/himo-rpc-framework 中的以下命令放在 mainto/php-rpc-framework-tool 库维护
     + `rpc:doc_clean`             clean document cache
     + `rpc:doc_upload`            upload document
     + `rpc:dump`                  RPC Router Dumper bridge
     + `rpc:dump-mainto-sdk`       RPC Router Dumper mainto-sdk
     + `rpc:dump-mainto-sdk-js`    RPC Router Dumper
     + `rpc:dump-service-api`      RPC Service Api Dumper
     + `rpc:make-controller-test`  Make RPC Controller Test
     + `rpc:mock`                  RPC Router Dumper mock
+ **框架本地启动命令由 `php artisan rpc:agent start` 更换为 `php artisan rpc:sidecar start worker`**
+ **框架不再依赖`predis/predis`, 项目中有依赖redis缓存的需自行引入 `predis/predis`**
+ 配置项和环境变量变更较多，详细部分看新版的 src/config.php
+ 新增LogHandler 用于对Laravel的Log类处理

######  环境变量-变更

// 环境变量默认值仅表示代码中的默认值，实际配置需根据环境和服务来配置

| 旧  | 新  | 默认 | 说明 |
| ------------ | ------------ | ------------ | ------------ |
|  RPC_CONFIG |  RPC_SIDECAR_ETCD_SERVER_ADDRESS | 127.0.0.1:2379 | 服务注册中心地址 |
|  CRON_ENABLE |  RPC_CRON_ENABLE | true | 是否启用定时任务 |
| RABBITMQ_ENABLE | RPC_SIDECAR_RABBIT_ENABLE |  true | 是否启用rabbmitmq消息队列 |
| RABBITMQ_HOST | RPC_SIDECAR_RABBIT_HOST | 127.0.0.1 | rabbmitmq host |
| RABBITMQ_PORT | RPC_SIDECAR_RABBIT_PORT | 5672 | rabbmitmq port |
| RABBITMQ_PASSWORD | RPC_SIDECAR_RABBIT_PASSWORD | guest | - |
| RABBITMQ_USERNAME | RPC_SIDECAR_RABBIT_USERNAME | manto | - |
| PHP_AGENT_DEBUG_SERVE_PORT | RPC_SIDECAR_METRICS_SERVER_PORT |  随机 | debug / 指标服务 端口 |
| ALIYUN_LOG_MICRO | RPC_SIDECAR_SLS_SERVER_ADDRESS | 127.0.0.1:3455 | 日志中心地址 |
| RPC_SETTING | RPC_SIDECAR_SETTING | false | 是否启用配置中心 |
| RPC_LISTEN | RPC_SIDECAR_WORKER_SERVER_HOST | 0.0.0.0 | 服务监听地址 |
| RPC_PORT | RPC_SIDECAR_WORKER_SERVER_PORT | 2233 | 服务监听端口 |
| PHP_AGENT_MIN_WORKER_NUM | RPC_SIDECAR_WORKER_MIN_WORKER_NUM | 8 | 最小worker数|
| PHP_AGENT_MAX_WORKER_NUM | RPC_SIDECAR_WORKER_MAX_WORKER_NUM | 500 | 最大worker数|

######  环境变量-新增
| 新  | 默认 | 说明 |
| ------------ | ------------ | ------------ |
|  RPC_SIDECAR_PHP_BASE_CMD | 环境中的 php | 配置符合版本的php执行文件 |
|  RPC_SIDECAR_LOG_ENABLE_LOAD_DEBUG | false | 输出worker的负载 |
|  RPC_SIDECAR_LOG_CONSOLE_ENABLE | false | 将sidecar的日志输出到终端 |
|  RPC_SIDECAR_PHP_INI_FILE | 环境中php配置的 ini | 指定运行php程序时使用的ini文件(可用于项目个性化的本地ini文件，如xdebug配置)|
|  RPC_SIDECAR_METRICS_PUSH_ENABLE | 开启指标推送模式 | 本地由于端口ip不固定，可以使用主动推送模式，上报指标 |

######  环境变量-弃用
+ WORKER_NUM
+ RPC_LOCAL
+ RPC_VERBOSE_MODE (转变为用logging的日志级别控制, rpc请求详细日志为debug级别)
