<?php

namespace Mainto\ThriftHbase\Thrift\Server;

use Mainto\ThriftHbase\Thrift\Exception\TTransportException;

/**
 * Generic class for Server agent.
 *
 * @package thrift.transport
 */
abstract class TServerTransport {
    /**
     * List for new clients
     *
     * @abstract
     * @return void
     */
    abstract public function listen ();

    /**
     * Close the server
     *
     * @abstract
     * @return void
     */
    abstract public function close ();

    /**
     * Uses the accept implemtation. If null is returned, an
     * exception is thrown.
     *
     * @return TTransport
     * @throws TTransportException
     */
    public function accept () {
        $transport = $this->acceptImpl();

        if ($transport == null) {
            throw new TTransportException("accept() may not return NULL");
        }

        return $transport;
    }

    /**
     * Subclasses should use this to implement
     * accept.
     *
     * @abstract
     * @return TTransport
     */
    protected abstract function acceptImpl ();
}
