<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

/**
 * A Scan object is used to specify scanner parameters when opening a scanner.
 */
class TScan {
    static $_TSPEC;

    /**
     * @var string
     */
    public $startRow = null;
    /**
     * @var string
     */
    public $stopRow = null;
    /**
     * @var int
     */
    public $timestamp = null;
    /**
     * @var string[]
     */
    public $columns = null;
    /**
     * @var int
     */
    public $caching = null;
    /**
     * @var string
     */
    public $filterString = null;
    /**
     * @var int
     */
    public $batchSize = null;
    /**
     * @var bool
     */
    public $sortColumns = null;
    /**
     * @var bool
     */
    public $reversed = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'startRow',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'  => 'stopRow',
                    'type' => TType::STRING,
                ],
                3 => [
                    'var'  => 'timestamp',
                    'type' => TType::I64,
                ],
                4 => [
                    'var'   => 'columns',
                    'type'  => TType::LST,
                    'etype' => TType::STRING,
                    'elem'  => [
                        'type' => TType::STRING,
                    ],
                ],
                5 => [
                    'var'  => 'caching',
                    'type' => TType::I32,
                ],
                6 => [
                    'var'  => 'filterString',
                    'type' => TType::STRING,
                ],
                7 => [
                    'var'  => 'batchSize',
                    'type' => TType::I32,
                ],
                8 => [
                    'var'  => 'sortColumns',
                    'type' => TType::BOOL,
                ],
                9 => [
                    'var'  => 'reversed',
                    'type' => TType::BOOL,
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['startRow'])) {
                $this->startRow = $vals['startRow'];
            }
            if (isset($vals['stopRow'])) {
                $this->stopRow = $vals['stopRow'];
            }
            if (isset($vals['timestamp'])) {
                $this->timestamp = $vals['timestamp'];
            }
            if (isset($vals['columns'])) {
                $this->columns = $vals['columns'];
            }
            if (isset($vals['caching'])) {
                $this->caching = $vals['caching'];
            }
            if (isset($vals['filterString'])) {
                $this->filterString = $vals['filterString'];
            }
            if (isset($vals['batchSize'])) {
                $this->batchSize = $vals['batchSize'];
            }
            if (isset($vals['sortColumns'])) {
                $this->sortColumns = $vals['sortColumns'];
            }
            if (isset($vals['reversed'])) {
                $this->reversed = $vals['reversed'];
            }
        }
    }

    public function getName () {
        return 'TScan';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->startRow);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->stopRow);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::I64) {
                        $xfer += $input->readI64($this->timestamp);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::LST) {
                        $this->columns = [];
                        $_size23 = 0;
                        $_etype26 = 0;
                        $xfer += $input->readListBegin($_etype26, $_size23);
                        for ($_i27 = 0; $_i27 < $_size23; ++$_i27) {
                            $elem28 = null;
                            $xfer += $input->readString($elem28);
                            $this->columns [] = $elem28;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 5:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->caching);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 6:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->filterString);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 7:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->batchSize);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 8:
                    if ($ftype == TType::BOOL) {
                        $xfer += $input->readBool($this->sortColumns);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 9:
                    if ($ftype == TType::BOOL) {
                        $xfer += $input->readBool($this->reversed);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('TScan');
        if ($this->startRow !== null) {
            $xfer += $output->writeFieldBegin('startRow', TType::STRING, 1);
            $xfer += $output->writeString($this->startRow);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->stopRow !== null) {
            $xfer += $output->writeFieldBegin('stopRow', TType::STRING, 2);
            $xfer += $output->writeString($this->stopRow);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->timestamp !== null) {
            $xfer += $output->writeFieldBegin('timestamp', TType::I64, 3);
            $xfer += $output->writeI64($this->timestamp);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->columns !== null) {
            if (!is_array($this->columns)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('columns', TType::LST, 4);
            {
                $output->writeListBegin(TType::STRING, count($this->columns));
                {
                    foreach ($this->columns as $iter29) {
                        $xfer += $output->writeString($iter29);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->caching !== null) {
            $xfer += $output->writeFieldBegin('caching', TType::I32, 5);
            $xfer += $output->writeI32($this->caching);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->filterString !== null) {
            $xfer += $output->writeFieldBegin('filterString', TType::STRING, 6);
            $xfer += $output->writeString($this->filterString);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->batchSize !== null) {
            $xfer += $output->writeFieldBegin('batchSize', TType::I32, 7);
            $xfer += $output->writeI32($this->batchSize);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->sortColumns !== null) {
            $xfer += $output->writeFieldBegin('sortColumns', TType::BOOL, 8);
            $xfer += $output->writeBool($this->sortColumns);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->reversed !== null) {
            $xfer += $output->writeFieldBegin('reversed', TType::BOOL, 9);
            $xfer += $output->writeBool($this->reversed);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}