<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

/**
 * Holds row name and then a map of columns to cells.
 */
class TRowResult {
    static $_TSPEC;

    /**
     * @var string
     */
    public $row = null;
    /**
     * @var array
     */
    public $columns = null;
    /**
     * @var \Mainto\ThriftHbase\Hbase\TColumn[]
     */
    public $sortedColumns = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'row',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'   => 'columns',
                    'type'  => TType::MAP,
                    'ktype' => TType::STRING,
                    'vtype' => TType::STRUCT,
                    'key'   => [
                        'type' => TType::STRING,
                    ],
                    'val'   => [
                        'type'  => TType::STRUCT,
                        'class' => '\Mainto\ThriftHbase\Hbase\TCell',
                    ],
                ],
                3 => [
                    'var'   => 'sortedColumns',
                    'type'  => TType::LST,
                    'etype' => TType::STRUCT,
                    'elem'  => [
                        'type'  => TType::STRUCT,
                        'class' => '\Mainto\ThriftHbase\Hbase\TColumn',
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['row'])) {
                $this->row = $vals['row'];
            }
            if (isset($vals['columns'])) {
                $this->columns = $vals['columns'];
            }
            if (isset($vals['sortedColumns'])) {
                $this->sortedColumns = $vals['sortedColumns'];
            }
        }
    }

    public function getName () {
        return 'TRowResult';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->row);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::MAP) {
                        $this->columns = [];
                        $_size7 = 0;
                        $_ktype8 = 0;
                        $_vtype9 = 0;
                        $xfer += $input->readMapBegin($_ktype8, $_vtype9, $_size7);
                        for ($_i11 = 0; $_i11 < $_size7; ++$_i11) {
                            $key12 = '';
                            $val13 = new \Mainto\ThriftHbase\Hbase\TCell();
                            $xfer += $input->readString($key12);
                            $val13 = new \Mainto\ThriftHbase\Hbase\TCell();
                            $xfer += $val13->read($input);
                            $this->columns[$key12] = $val13;
                        }
                        $xfer += $input->readMapEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::LST) {
                        $this->sortedColumns = [];
                        $_size14 = 0;
                        $_etype17 = 0;
                        $xfer += $input->readListBegin($_etype17, $_size14);
                        for ($_i18 = 0; $_i18 < $_size14; ++$_i18) {
                            $elem19 = null;
                            $elem19 = new \Mainto\ThriftHbase\Hbase\TColumn();
                            $xfer += $elem19->read($input);
                            $this->sortedColumns [] = $elem19;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('TRowResult');
        if ($this->row !== null) {
            $xfer += $output->writeFieldBegin('row', TType::STRING, 1);
            $xfer += $output->writeString($this->row);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->columns !== null) {
            if (!is_array($this->columns)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('columns', TType::MAP, 2);
            {
                $output->writeMapBegin(TType::STRING, TType::STRUCT, count($this->columns));
                {
                    foreach ($this->columns as $kiter20 => $viter21) {
                        $xfer += $output->writeString($kiter20);
                        $xfer += $viter21->write($output);
                    }
                }
                $output->writeMapEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->sortedColumns !== null) {
            if (!is_array($this->sortedColumns)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('sortedColumns', TType::LST, 3);
            {
                $output->writeListBegin(TType::STRUCT, count($this->sortedColumns));
                {
                    foreach ($this->sortedColumns as $iter22) {
                        $xfer += $iter22->write($output);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}