<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Type\TType;

/**
 * A TRegionInfo contains information about an HTable region.
 */
class TRegionInfo {
    static $_TSPEC;

    /**
     * @var string
     */
    public $startKey = null;
    /**
     * @var string
     */
    public $endKey = null;
    /**
     * @var int
     */
    public $id = null;
    /**
     * @var string
     */
    public $name = null;
    /**
     * @var int
     */
    public $version = null;
    /**
     * @var string
     */
    public $serverName = null;
    /**
     * @var int
     */
    public $port = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'startKey',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'  => 'endKey',
                    'type' => TType::STRING,
                ],
                3 => [
                    'var'  => 'id',
                    'type' => TType::I64,
                ],
                4 => [
                    'var'  => 'name',
                    'type' => TType::STRING,
                ],
                5 => [
                    'var'  => 'version',
                    'type' => TType::BYTE,
                ],
                6 => [
                    'var'  => 'serverName',
                    'type' => TType::STRING,
                ],
                7 => [
                    'var'  => 'port',
                    'type' => TType::I32,
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['startKey'])) {
                $this->startKey = $vals['startKey'];
            }
            if (isset($vals['endKey'])) {
                $this->endKey = $vals['endKey'];
            }
            if (isset($vals['id'])) {
                $this->id = $vals['id'];
            }
            if (isset($vals['name'])) {
                $this->name = $vals['name'];
            }
            if (isset($vals['version'])) {
                $this->version = $vals['version'];
            }
            if (isset($vals['serverName'])) {
                $this->serverName = $vals['serverName'];
            }
            if (isset($vals['port'])) {
                $this->port = $vals['port'];
            }
        }
    }

    public function getName () {
        return 'TRegionInfo';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->startKey);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->endKey);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::I64) {
                        $xfer += $input->readI64($this->id);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->name);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 5:
                    if ($ftype == TType::BYTE) {
                        $xfer += $input->readByte($this->version);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 6:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->serverName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 7:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->port);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('TRegionInfo');
        if ($this->startKey !== null) {
            $xfer += $output->writeFieldBegin('startKey', TType::STRING, 1);
            $xfer += $output->writeString($this->startKey);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->endKey !== null) {
            $xfer += $output->writeFieldBegin('endKey', TType::STRING, 2);
            $xfer += $output->writeString($this->endKey);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->id !== null) {
            $xfer += $output->writeFieldBegin('id', TType::I64, 3);
            $xfer += $output->writeI64($this->id);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->name !== null) {
            $xfer += $output->writeFieldBegin('name', TType::STRING, 4);
            $xfer += $output->writeString($this->name);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->version !== null) {
            $xfer += $output->writeFieldBegin('version', TType::BYTE, 5);
            $xfer += $output->writeByte($this->version);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->serverName !== null) {
            $xfer += $output->writeFieldBegin('serverName', TType::STRING, 6);
            $xfer += $output->writeString($this->serverName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->port !== null) {
            $xfer += $output->writeFieldBegin('port', TType::I32, 7);
            $xfer += $output->writeI32($this->port);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}