<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Type\TType;

/**
 * For increments that are not incrementColumnValue
 * equivalents.
 */
class TIncrement {
    static $_TSPEC;

    /**
     * @var string
     */
    public $table = null;
    /**
     * @var string
     */
    public $row = null;
    /**
     * @var string
     */
    public $column = null;
    /**
     * @var int
     */
    public $ammount = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'table',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'  => 'row',
                    'type' => TType::STRING,
                ],
                3 => [
                    'var'  => 'column',
                    'type' => TType::STRING,
                ],
                4 => [
                    'var'  => 'ammount',
                    'type' => TType::I64,
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['table'])) {
                $this->table = $vals['table'];
            }
            if (isset($vals['row'])) {
                $this->row = $vals['row'];
            }
            if (isset($vals['column'])) {
                $this->column = $vals['column'];
            }
            if (isset($vals['ammount'])) {
                $this->ammount = $vals['ammount'];
            }
        }
    }

    public function getName () {
        return 'TIncrement';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->table);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->row);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->column);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::I64) {
                        $xfer += $input->readI64($this->ammount);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('TIncrement');
        if ($this->table !== null) {
            $xfer += $output->writeFieldBegin('table', TType::STRING, 1);
            $xfer += $output->writeString($this->table);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->row !== null) {
            $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
            $xfer += $output->writeString($this->row);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->column !== null) {
            $xfer += $output->writeFieldBegin('column', TType::STRING, 3);
            $xfer += $output->writeString($this->column);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->ammount !== null) {
            $xfer += $output->writeFieldBegin('ammount', TType::I64, 4);
            $xfer += $output->writeI64($this->ammount);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}