<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

/**
 * Holds column name and the cell.
 */
class TColumn {
    static $_TSPEC;

    /**
     * @var string
     */
    public $columnName = null;
    /**
     * @var \Mainto\ThriftHbase\Hbase\TCell
     */
    public $cell = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'columnName',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'   => 'cell',
                    'type'  => TType::STRUCT,
                    'class' => '\Mainto\ThriftHbase\Hbase\TCell',
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['columnName'])) {
                $this->columnName = $vals['columnName'];
            }
            if (isset($vals['cell'])) {
                $this->cell = $vals['cell'];
            }
        }
    }

    public function getName () {
        return 'TColumn';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->columnName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRUCT) {
                        $this->cell = new \Mainto\ThriftHbase\Hbase\TCell();
                        $xfer += $this->cell->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('TColumn');
        if ($this->columnName !== null) {
            $xfer += $output->writeFieldBegin('columnName', TType::STRING, 1);
            $xfer += $output->writeString($this->columnName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->cell !== null) {
            if (!is_object($this->cell)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('cell', TType::STRUCT, 2);
            $xfer += $this->cell->write($output);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}