<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Type\TType;

/**
 * A Mutation object is used to either update or delete a column-value.
 */
class Mutation {
    static $_TSPEC;

    /**
     * @var bool
     */
    public $isDelete = false;
    /**
     * @var string
     */
    public $column = null;
    /**
     * @var string
     */
    public $value = null;
    /**
     * @var bool
     */
    public $writeToWAL = true;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'isDelete',
                    'type' => TType::BOOL,
                ],
                2 => [
                    'var'  => 'column',
                    'type' => TType::STRING,
                ],
                3 => [
                    'var'  => 'value',
                    'type' => TType::STRING,
                ],
                4 => [
                    'var'  => 'writeToWAL',
                    'type' => TType::BOOL,
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['isDelete'])) {
                $this->isDelete = $vals['isDelete'];
            }
            if (isset($vals['column'])) {
                $this->column = $vals['column'];
            }
            if (isset($vals['value'])) {
                $this->value = $vals['value'];
            }
            if (isset($vals['writeToWAL'])) {
                $this->writeToWAL = $vals['writeToWAL'];
            }
        }
    }

    public function getName () {
        return 'Mutation';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::BOOL) {
                        $xfer += $input->readBool($this->isDelete);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->column);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->value);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::BOOL) {
                        $xfer += $input->readBool($this->writeToWAL);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Mutation');
        if ($this->isDelete !== null) {
            $xfer += $output->writeFieldBegin('isDelete', TType::BOOL, 1);
            $xfer += $output->writeBool($this->isDelete);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->column !== null) {
            $xfer += $output->writeFieldBegin('column', TType::STRING, 2);
            $xfer += $output->writeString($this->column);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->value !== null) {
            $xfer += $output->writeFieldBegin('value', TType::STRING, 3);
            $xfer += $output->writeString($this->value);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->writeToWAL !== null) {
            $xfer += $output->writeFieldBegin('writeToWAL', TType::BOOL, 4);
            $xfer += $output->writeBool($this->writeToWAL);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}