<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_scannerOpenWithStop_args {
    static $_TSPEC;

    /**
     * name of table
     *
     * @var string
     */
    public $tableName = null;
    /**
     * Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     *
     * @var string
     */
    public $startRow = null;
    /**
     * row to stop scanning on. This row is *not* included in the
     * scanner's results
     *
     * @var string
     */
    public $stopRow = null;
    /**
     * columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     *
     * @var string[]
     */
    public $columns = null;
    /**
     * Scan attributes
     *
     * @var array
     */
    public $attributes = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'tableName',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'  => 'startRow',
                    'type' => TType::STRING,
                ],
                3 => [
                    'var'  => 'stopRow',
                    'type' => TType::STRING,
                ],
                4 => [
                    'var'   => 'columns',
                    'type'  => TType::LST,
                    'etype' => TType::STRING,
                    'elem'  => [
                        'type' => TType::STRING,
                    ],
                ],
                5 => [
                    'var'   => 'attributes',
                    'type'  => TType::MAP,
                    'ktype' => TType::STRING,
                    'vtype' => TType::STRING,
                    'key'   => [
                        'type' => TType::STRING,
                    ],
                    'val'   => [
                        'type' => TType::STRING,
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['tableName'])) {
                $this->tableName = $vals['tableName'];
            }
            if (isset($vals['startRow'])) {
                $this->startRow = $vals['startRow'];
            }
            if (isset($vals['stopRow'])) {
                $this->stopRow = $vals['stopRow'];
            }
            if (isset($vals['columns'])) {
                $this->columns = $vals['columns'];
            }
            if (isset($vals['attributes'])) {
                $this->attributes = $vals['attributes'];
            }
        }
    }

    public function getName () {
        return 'Hbase_scannerOpenWithStop_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->tableName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->startRow);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->stopRow);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::LST) {
                        $this->columns = [];
                        $_size438 = 0;
                        $_etype441 = 0;
                        $xfer += $input->readListBegin($_etype441, $_size438);
                        for ($_i442 = 0; $_i442 < $_size438; ++$_i442) {
                            $elem443 = null;
                            $xfer += $input->readString($elem443);
                            $this->columns [] = $elem443;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 5:
                    if ($ftype == TType::MAP) {
                        $this->attributes = [];
                        $_size444 = 0;
                        $_ktype445 = 0;
                        $_vtype446 = 0;
                        $xfer += $input->readMapBegin($_ktype445, $_vtype446, $_size444);
                        for ($_i448 = 0; $_i448 < $_size444; ++$_i448) {
                            $key449 = '';
                            $val450 = '';
                            $xfer += $input->readString($key449);
                            $xfer += $input->readString($val450);
                            $this->attributes[$key449] = $val450;
                        }
                        $xfer += $input->readMapEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_scannerOpenWithStop_args');
        if ($this->tableName !== null) {
            $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
            $xfer += $output->writeString($this->tableName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->startRow !== null) {
            $xfer += $output->writeFieldBegin('startRow', TType::STRING, 2);
            $xfer += $output->writeString($this->startRow);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->stopRow !== null) {
            $xfer += $output->writeFieldBegin('stopRow', TType::STRING, 3);
            $xfer += $output->writeString($this->stopRow);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->columns !== null) {
            if (!is_array($this->columns)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('columns', TType::LST, 4);
            {
                $output->writeListBegin(TType::STRING, count($this->columns));
                {
                    foreach ($this->columns as $iter451) {
                        $xfer += $output->writeString($iter451);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->attributes !== null) {
            if (!is_array($this->attributes)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
            {
                $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
                {
                    foreach ($this->attributes as $kiter452 => $viter453) {
                        $xfer += $output->writeString($kiter452);
                        $xfer += $output->writeString($viter453);
                    }
                }
                $output->writeMapEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}