<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_scannerOpenWithStopTs_args {
    static $_TSPEC;

    /**
     * name of table
     *
     * @var string
     */
    public $tableName = null;
    /**
     * Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     *
     * @var string
     */
    public $startRow = null;
    /**
     * row to stop scanning on. This row is *not* included in the
     * scanner's results
     *
     * @var string
     */
    public $stopRow = null;
    /**
     * columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     *
     * @var string[]
     */
    public $columns = null;
    /**
     * timestamp
     *
     * @var int
     */
    public $timestamp = null;
    /**
     * Scan attributes
     *
     * @var array
     */
    public $attributes = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'tableName',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'  => 'startRow',
                    'type' => TType::STRING,
                ],
                3 => [
                    'var'  => 'stopRow',
                    'type' => TType::STRING,
                ],
                4 => [
                    'var'   => 'columns',
                    'type'  => TType::LST,
                    'etype' => TType::STRING,
                    'elem'  => [
                        'type' => TType::STRING,
                    ],
                ],
                5 => [
                    'var'  => 'timestamp',
                    'type' => TType::I64,
                ],
                6 => [
                    'var'   => 'attributes',
                    'type'  => TType::MAP,
                    'ktype' => TType::STRING,
                    'vtype' => TType::STRING,
                    'key'   => [
                        'type' => TType::STRING,
                    ],
                    'val'   => [
                        'type' => TType::STRING,
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['tableName'])) {
                $this->tableName = $vals['tableName'];
            }
            if (isset($vals['startRow'])) {
                $this->startRow = $vals['startRow'];
            }
            if (isset($vals['stopRow'])) {
                $this->stopRow = $vals['stopRow'];
            }
            if (isset($vals['columns'])) {
                $this->columns = $vals['columns'];
            }
            if (isset($vals['timestamp'])) {
                $this->timestamp = $vals['timestamp'];
            }
            if (isset($vals['attributes'])) {
                $this->attributes = $vals['attributes'];
            }
        }
    }

    public function getName () {
        return 'Hbase_scannerOpenWithStopTs_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->tableName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->startRow);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->stopRow);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::LST) {
                        $this->columns = [];
                        $_size486 = 0;
                        $_etype489 = 0;
                        $xfer += $input->readListBegin($_etype489, $_size486);
                        for ($_i490 = 0; $_i490 < $_size486; ++$_i490) {
                            $elem491 = null;
                            $xfer += $input->readString($elem491);
                            $this->columns [] = $elem491;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 5:
                    if ($ftype == TType::I64) {
                        $xfer += $input->readI64($this->timestamp);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 6:
                    if ($ftype == TType::MAP) {
                        $this->attributes = [];
                        $_size492 = 0;
                        $_ktype493 = 0;
                        $_vtype494 = 0;
                        $xfer += $input->readMapBegin($_ktype493, $_vtype494, $_size492);
                        for ($_i496 = 0; $_i496 < $_size492; ++$_i496) {
                            $key497 = '';
                            $val498 = '';
                            $xfer += $input->readString($key497);
                            $xfer += $input->readString($val498);
                            $this->attributes[$key497] = $val498;
                        }
                        $xfer += $input->readMapEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_scannerOpenWithStopTs_args');
        if ($this->tableName !== null) {
            $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
            $xfer += $output->writeString($this->tableName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->startRow !== null) {
            $xfer += $output->writeFieldBegin('startRow', TType::STRING, 2);
            $xfer += $output->writeString($this->startRow);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->stopRow !== null) {
            $xfer += $output->writeFieldBegin('stopRow', TType::STRING, 3);
            $xfer += $output->writeString($this->stopRow);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->columns !== null) {
            if (!is_array($this->columns)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('columns', TType::LST, 4);
            {
                $output->writeListBegin(TType::STRING, count($this->columns));
                {
                    foreach ($this->columns as $iter499) {
                        $xfer += $output->writeString($iter499);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->timestamp !== null) {
            $xfer += $output->writeFieldBegin('timestamp', TType::I64, 5);
            $xfer += $output->writeI64($this->timestamp);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->attributes !== null) {
            if (!is_array($this->attributes)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('attributes', TType::MAP, 6);
            {
                $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
                {
                    foreach ($this->attributes as $kiter500 => $viter501) {
                        $xfer += $output->writeString($kiter500);
                        $xfer += $output->writeString($viter501);
                    }
                }
                $output->writeMapEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}