<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_scannerOpenTs_args {
    static $_TSPEC;

    /**
     * name of table
     *
     * @var string
     */
    public $tableName = null;
    /**
     * Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     *
     * @var string
     */
    public $startRow = null;
    /**
     * columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     *
     * @var string[]
     */
    public $columns = null;
    /**
     * timestamp
     *
     * @var int
     */
    public $timestamp = null;
    /**
     * Scan attributes
     *
     * @var array
     */
    public $attributes = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'tableName',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'  => 'startRow',
                    'type' => TType::STRING,
                ],
                3 => [
                    'var'   => 'columns',
                    'type'  => TType::LST,
                    'etype' => TType::STRING,
                    'elem'  => [
                        'type' => TType::STRING,
                    ],
                ],
                4 => [
                    'var'  => 'timestamp',
                    'type' => TType::I64,
                ],
                5 => [
                    'var'   => 'attributes',
                    'type'  => TType::MAP,
                    'ktype' => TType::STRING,
                    'vtype' => TType::STRING,
                    'key'   => [
                        'type' => TType::STRING,
                    ],
                    'val'   => [
                        'type' => TType::STRING,
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['tableName'])) {
                $this->tableName = $vals['tableName'];
            }
            if (isset($vals['startRow'])) {
                $this->startRow = $vals['startRow'];
            }
            if (isset($vals['columns'])) {
                $this->columns = $vals['columns'];
            }
            if (isset($vals['timestamp'])) {
                $this->timestamp = $vals['timestamp'];
            }
            if (isset($vals['attributes'])) {
                $this->attributes = $vals['attributes'];
            }
        }
    }

    public function getName () {
        return 'Hbase_scannerOpenTs_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->tableName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->startRow);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::LST) {
                        $this->columns = [];
                        $_size470 = 0;
                        $_etype473 = 0;
                        $xfer += $input->readListBegin($_etype473, $_size470);
                        for ($_i474 = 0; $_i474 < $_size470; ++$_i474) {
                            $elem475 = null;
                            $xfer += $input->readString($elem475);
                            $this->columns [] = $elem475;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::I64) {
                        $xfer += $input->readI64($this->timestamp);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 5:
                    if ($ftype == TType::MAP) {
                        $this->attributes = [];
                        $_size476 = 0;
                        $_ktype477 = 0;
                        $_vtype478 = 0;
                        $xfer += $input->readMapBegin($_ktype477, $_vtype478, $_size476);
                        for ($_i480 = 0; $_i480 < $_size476; ++$_i480) {
                            $key481 = '';
                            $val482 = '';
                            $xfer += $input->readString($key481);
                            $xfer += $input->readString($val482);
                            $this->attributes[$key481] = $val482;
                        }
                        $xfer += $input->readMapEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_scannerOpenTs_args');
        if ($this->tableName !== null) {
            $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
            $xfer += $output->writeString($this->tableName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->startRow !== null) {
            $xfer += $output->writeFieldBegin('startRow', TType::STRING, 2);
            $xfer += $output->writeString($this->startRow);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->columns !== null) {
            if (!is_array($this->columns)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('columns', TType::LST, 3);
            {
                $output->writeListBegin(TType::STRING, count($this->columns));
                {
                    foreach ($this->columns as $iter483) {
                        $xfer += $output->writeString($iter483);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->timestamp !== null) {
            $xfer += $output->writeFieldBegin('timestamp', TType::I64, 4);
            $xfer += $output->writeI64($this->timestamp);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->attributes !== null) {
            if (!is_array($this->attributes)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
            {
                $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
                {
                    foreach ($this->attributes as $kiter484 => $viter485) {
                        $xfer += $output->writeString($kiter484);
                        $xfer += $output->writeString($viter485);
                    }
                }
                $output->writeMapEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}