<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_scannerGetList_result {
    static $_TSPEC;

    /**
     * @var \Mainto\ThriftHbase\Hbase\TRowResult[]
     */
    public $success = null;
    /**
     * @var \Mainto\ThriftHbase\Hbase\IOError
     */
    public $io = null;
    /**
     * @var \Mainto\ThriftHbase\Hbase\IllegalArgument
     */
    public $ia = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                0 => [
                    'var'   => 'success',
                    'type'  => TType::LST,
                    'etype' => TType::STRUCT,
                    'elem'  => [
                        'type'  => TType::STRUCT,
                        'class' => '\Mainto\ThriftHbase\Hbase\TRowResult',
                    ],
                ],
                1 => [
                    'var'   => 'io',
                    'type'  => TType::STRUCT,
                    'class' => '\Mainto\ThriftHbase\Hbase\IOError',
                ],
                2 => [
                    'var'   => 'ia',
                    'type'  => TType::STRUCT,
                    'class' => '\Mainto\ThriftHbase\Hbase\IllegalArgument',
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['success'])) {
                $this->success = $vals['success'];
            }
            if (isset($vals['io'])) {
                $this->io = $vals['io'];
            }
            if (isset($vals['ia'])) {
                $this->ia = $vals['ia'];
            }
        }
    }

    public function getName () {
        return 'Hbase_scannerGetList_result';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 0:
                    if ($ftype == TType::LST) {
                        $this->success = [];
                        $_size509 = 0;
                        $_etype512 = 0;
                        $xfer += $input->readListBegin($_etype512, $_size509);
                        for ($_i513 = 0; $_i513 < $_size509; ++$_i513) {
                            $elem514 = null;
                            $elem514 = new \Mainto\ThriftHbase\Hbase\TRowResult();
                            $xfer += $elem514->read($input);
                            $this->success [] = $elem514;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 1:
                    if ($ftype == TType::STRUCT) {
                        $this->io = new \Mainto\ThriftHbase\Hbase\IOError();
                        $xfer += $this->io->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRUCT) {
                        $this->ia = new \Mainto\ThriftHbase\Hbase\IllegalArgument();
                        $xfer += $this->ia->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_scannerGetList_result');
        if ($this->success !== null) {
            if (!is_array($this->success)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('success', TType::LST, 0);
            {
                $output->writeListBegin(TType::STRUCT, count($this->success));
                {
                    foreach ($this->success as $iter515) {
                        $xfer += $iter515->write($output);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->io !== null) {
            $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
            $xfer += $this->io->write($output);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->ia !== null) {
            $xfer += $output->writeFieldBegin('ia', TType::STRUCT, 2);
            $xfer += $this->ia->write($output);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}