<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_mutateRows_args {
    static $_TSPEC;

    /**
     * name of table
     *
     * @var string
     */
    public $tableName = null;
    /**
     * list of row batches
     *
     * @var \Mainto\ThriftHbase\Hbase\BatchMutation[]
     */
    public $rowBatches = null;
    /**
     * Mutation attributes
     *
     * @var array
     */
    public $attributes = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'tableName',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'   => 'rowBatches',
                    'type'  => TType::LST,
                    'etype' => TType::STRUCT,
                    'elem'  => [
                        'type'  => TType::STRUCT,
                        'class' => '\Mainto\ThriftHbase\Hbase\BatchMutation',
                    ],
                ],
                3 => [
                    'var'   => 'attributes',
                    'type'  => TType::MAP,
                    'ktype' => TType::STRING,
                    'vtype' => TType::STRING,
                    'key'   => [
                        'type' => TType::STRING,
                    ],
                    'val'   => [
                        'type' => TType::STRING,
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['tableName'])) {
                $this->tableName = $vals['tableName'];
            }
            if (isset($vals['rowBatches'])) {
                $this->rowBatches = $vals['rowBatches'];
            }
            if (isset($vals['attributes'])) {
                $this->attributes = $vals['attributes'];
            }
        }
    }

    public function getName () {
        return 'Hbase_mutateRows_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->tableName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::LST) {
                        $this->rowBatches = [];
                        $_size338 = 0;
                        $_etype341 = 0;
                        $xfer += $input->readListBegin($_etype341, $_size338);
                        for ($_i342 = 0; $_i342 < $_size338; ++$_i342) {
                            $elem343 = null;
                            $elem343 = new \Mainto\ThriftHbase\Hbase\BatchMutation();
                            $xfer += $elem343->read($input);
                            $this->rowBatches [] = $elem343;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::MAP) {
                        $this->attributes = [];
                        $_size344 = 0;
                        $_ktype345 = 0;
                        $_vtype346 = 0;
                        $xfer += $input->readMapBegin($_ktype345, $_vtype346, $_size344);
                        for ($_i348 = 0; $_i348 < $_size344; ++$_i348) {
                            $key349 = '';
                            $val350 = '';
                            $xfer += $input->readString($key349);
                            $xfer += $input->readString($val350);
                            $this->attributes[$key349] = $val350;
                        }
                        $xfer += $input->readMapEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_mutateRows_args');
        if ($this->tableName !== null) {
            $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
            $xfer += $output->writeString($this->tableName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->rowBatches !== null) {
            if (!is_array($this->rowBatches)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('rowBatches', TType::LST, 2);
            {
                $output->writeListBegin(TType::STRUCT, count($this->rowBatches));
                {
                    foreach ($this->rowBatches as $iter351) {
                        $xfer += $iter351->write($output);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->attributes !== null) {
            if (!is_array($this->attributes)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('attributes', TType::MAP, 3);
            {
                $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
                {
                    foreach ($this->attributes as $kiter352 => $viter353) {
                        $xfer += $output->writeString($kiter352);
                        $xfer += $output->writeString($viter353);
                    }
                }
                $output->writeMapEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}