<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_mutateRowsTs_args {
    static $_TSPEC;

    /**
     * name of table
     *
     * @var string
     */
    public $tableName = null;
    /**
     * list of row batches
     *
     * @var \Mainto\ThriftHbase\Hbase\BatchMutation[]
     */
    public $rowBatches = null;
    /**
     * timestamp
     *
     * @var int
     */
    public $timestamp = null;
    /**
     * Mutation attributes
     *
     * @var array
     */
    public $attributes = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'tableName',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'   => 'rowBatches',
                    'type'  => TType::LST,
                    'etype' => TType::STRUCT,
                    'elem'  => [
                        'type'  => TType::STRUCT,
                        'class' => '\Mainto\ThriftHbase\Hbase\BatchMutation',
                    ],
                ],
                3 => [
                    'var'  => 'timestamp',
                    'type' => TType::I64,
                ],
                4 => [
                    'var'   => 'attributes',
                    'type'  => TType::MAP,
                    'ktype' => TType::STRING,
                    'vtype' => TType::STRING,
                    'key'   => [
                        'type' => TType::STRING,
                    ],
                    'val'   => [
                        'type' => TType::STRING,
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['tableName'])) {
                $this->tableName = $vals['tableName'];
            }
            if (isset($vals['rowBatches'])) {
                $this->rowBatches = $vals['rowBatches'];
            }
            if (isset($vals['timestamp'])) {
                $this->timestamp = $vals['timestamp'];
            }
            if (isset($vals['attributes'])) {
                $this->attributes = $vals['attributes'];
            }
        }
    }

    public function getName () {
        return 'Hbase_mutateRowsTs_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->tableName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::LST) {
                        $this->rowBatches = [];
                        $_size354 = 0;
                        $_etype357 = 0;
                        $xfer += $input->readListBegin($_etype357, $_size354);
                        for ($_i358 = 0; $_i358 < $_size354; ++$_i358) {
                            $elem359 = null;
                            $elem359 = new \Mainto\ThriftHbase\Hbase\BatchMutation();
                            $xfer += $elem359->read($input);
                            $this->rowBatches [] = $elem359;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::I64) {
                        $xfer += $input->readI64($this->timestamp);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::MAP) {
                        $this->attributes = [];
                        $_size360 = 0;
                        $_ktype361 = 0;
                        $_vtype362 = 0;
                        $xfer += $input->readMapBegin($_ktype361, $_vtype362, $_size360);
                        for ($_i364 = 0; $_i364 < $_size360; ++$_i364) {
                            $key365 = '';
                            $val366 = '';
                            $xfer += $input->readString($key365);
                            $xfer += $input->readString($val366);
                            $this->attributes[$key365] = $val366;
                        }
                        $xfer += $input->readMapEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_mutateRowsTs_args');
        if ($this->tableName !== null) {
            $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
            $xfer += $output->writeString($this->tableName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->rowBatches !== null) {
            if (!is_array($this->rowBatches)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('rowBatches', TType::LST, 2);
            {
                $output->writeListBegin(TType::STRUCT, count($this->rowBatches));
                {
                    foreach ($this->rowBatches as $iter367) {
                        $xfer += $iter367->write($output);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->timestamp !== null) {
            $xfer += $output->writeFieldBegin('timestamp', TType::I64, 3);
            $xfer += $output->writeI64($this->timestamp);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->attributes !== null) {
            if (!is_array($this->attributes)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('attributes', TType::MAP, 4);
            {
                $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
                {
                    foreach ($this->attributes as $kiter368 => $viter369) {
                        $xfer += $output->writeString($kiter368);
                        $xfer += $output->writeString($viter369);
                    }
                }
                $output->writeMapEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}