<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_increment_args {
    static $_TSPEC;

    /**
     * The single increment to apply
     *
     * @var \Mainto\ThriftHbase\Hbase\TIncrement
     */
    public $increment = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'   => 'increment',
                    'type'  => TType::STRUCT,
                    'class' => '\Mainto\ThriftHbase\Hbase\TIncrement',
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['increment'])) {
                $this->increment = $vals['increment'];
            }
        }
    }

    public function getName () {
        return 'Hbase_increment_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRUCT) {
                        $this->increment = new \Mainto\ThriftHbase\Hbase\TIncrement();
                        $xfer += $this->increment->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_increment_args');
        if ($this->increment !== null) {
            if (!is_object($this->increment)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('increment', TType::STRUCT, 1);
            $xfer += $this->increment->write($output);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}