<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_getVer_result {
    static $_TSPEC;

    /**
     * @var \Mainto\ThriftHbase\Hbase\TCell[]
     */
    public $success = null;
    /**
     * @var \Mainto\ThriftHbase\Hbase\IOError
     */
    public $io = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                0 => [
                    'var'   => 'success',
                    'type'  => TType::LST,
                    'etype' => TType::STRUCT,
                    'elem'  => [
                        'type'  => TType::STRUCT,
                        'class' => '\Mainto\ThriftHbase\Hbase\TCell',
                    ],
                ],
                1 => [
                    'var'   => 'io',
                    'type'  => TType::STRUCT,
                    'class' => '\Mainto\ThriftHbase\Hbase\IOError',
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['success'])) {
                $this->success = $vals['success'];
            }
            if (isset($vals['io'])) {
                $this->io = $vals['io'];
            }
        }
    }

    public function getName () {
        return 'Hbase_getVer_result';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 0:
                    if ($ftype == TType::LST) {
                        $this->success = [];
                        $_size99 = 0;
                        $_etype102 = 0;
                        $xfer += $input->readListBegin($_etype102, $_size99);
                        for ($_i103 = 0; $_i103 < $_size99; ++$_i103) {
                            $elem104 = null;
                            $elem104 = new \Mainto\ThriftHbase\Hbase\TCell();
                            $xfer += $elem104->read($input);
                            $this->success [] = $elem104;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 1:
                    if ($ftype == TType::STRUCT) {
                        $this->io = new \Mainto\ThriftHbase\Hbase\IOError();
                        $xfer += $this->io->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_getVer_result');
        if ($this->success !== null) {
            if (!is_array($this->success)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('success', TType::LST, 0);
            {
                $output->writeListBegin(TType::STRUCT, count($this->success));
                {
                    foreach ($this->success as $iter105) {
                        $xfer += $iter105->write($output);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->io !== null) {
            $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
            $xfer += $this->io->write($output);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}