<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_getVer_args {
    static $_TSPEC;

    /**
     * name of table
     *
     * @var string
     */
    public $tableName = null;
    /**
     * row key
     *
     * @var string
     */
    public $row = null;
    /**
     * column name
     *
     * @var string
     */
    public $column = null;
    /**
     * number of versions to retrieve
     *
     * @var int
     */
    public $numVersions = null;
    /**
     * Get attributes
     *
     * @var array
     */
    public $attributes = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'tableName',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'  => 'row',
                    'type' => TType::STRING,
                ],
                3 => [
                    'var'  => 'column',
                    'type' => TType::STRING,
                ],
                4 => [
                    'var'  => 'numVersions',
                    'type' => TType::I32,
                ],
                5 => [
                    'var'   => 'attributes',
                    'type'  => TType::MAP,
                    'ktype' => TType::STRING,
                    'vtype' => TType::STRING,
                    'key'   => [
                        'type' => TType::STRING,
                    ],
                    'val'   => [
                        'type' => TType::STRING,
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['tableName'])) {
                $this->tableName = $vals['tableName'];
            }
            if (isset($vals['row'])) {
                $this->row = $vals['row'];
            }
            if (isset($vals['column'])) {
                $this->column = $vals['column'];
            }
            if (isset($vals['numVersions'])) {
                $this->numVersions = $vals['numVersions'];
            }
            if (isset($vals['attributes'])) {
                $this->attributes = $vals['attributes'];
            }
        }
    }

    public function getName () {
        return 'Hbase_getVer_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->tableName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->row);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->column);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->numVersions);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 5:
                    if ($ftype == TType::MAP) {
                        $this->attributes = [];
                        $_size90 = 0;
                        $_ktype91 = 0;
                        $_vtype92 = 0;
                        $xfer += $input->readMapBegin($_ktype91, $_vtype92, $_size90);
                        for ($_i94 = 0; $_i94 < $_size90; ++$_i94) {
                            $key95 = '';
                            $val96 = '';
                            $xfer += $input->readString($key95);
                            $xfer += $input->readString($val96);
                            $this->attributes[$key95] = $val96;
                        }
                        $xfer += $input->readMapEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_getVer_args');
        if ($this->tableName !== null) {
            $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
            $xfer += $output->writeString($this->tableName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->row !== null) {
            $xfer += $output->writeFieldBegin('row', TType::STRING, 2);
            $xfer += $output->writeString($this->row);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->column !== null) {
            $xfer += $output->writeFieldBegin('column', TType::STRING, 3);
            $xfer += $output->writeString($this->column);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->numVersions !== null) {
            $xfer += $output->writeFieldBegin('numVersions', TType::I32, 4);
            $xfer += $output->writeI32($this->numVersions);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->attributes !== null) {
            if (!is_array($this->attributes)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('attributes', TType::MAP, 5);
            {
                $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
                {
                    foreach ($this->attributes as $kiter97 => $viter98) {
                        $xfer += $output->writeString($kiter97);
                        $xfer += $output->writeString($viter98);
                    }
                }
                $output->writeMapEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}