<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_getRows_args {
    static $_TSPEC;

    /**
     * name of table
     *
     * @var string
     */
    public $tableName = null;
    /**
     * row keys
     *
     * @var string[]
     */
    public $rows = null;
    /**
     * Get attributes
     *
     * @var array
     */
    public $attributes = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'tableName',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'   => 'rows',
                    'type'  => TType::LST,
                    'etype' => TType::STRING,
                    'elem'  => [
                        'type' => TType::STRING,
                    ],
                ],
                3 => [
                    'var'   => 'attributes',
                    'type'  => TType::MAP,
                    'ktype' => TType::STRING,
                    'vtype' => TType::STRING,
                    'key'   => [
                        'type' => TType::STRING,
                    ],
                    'val'   => [
                        'type' => TType::STRING,
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['tableName'])) {
                $this->tableName = $vals['tableName'];
            }
            if (isset($vals['rows'])) {
                $this->rows = $vals['rows'];
            }
            if (isset($vals['attributes'])) {
                $this->attributes = $vals['attributes'];
            }
        }
    }

    public function getName () {
        return 'Hbase_getRows_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->tableName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::LST) {
                        $this->rows = [];
                        $_size200 = 0;
                        $_etype203 = 0;
                        $xfer += $input->readListBegin($_etype203, $_size200);
                        for ($_i204 = 0; $_i204 < $_size200; ++$_i204) {
                            $elem205 = null;
                            $xfer += $input->readString($elem205);
                            $this->rows [] = $elem205;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::MAP) {
                        $this->attributes = [];
                        $_size206 = 0;
                        $_ktype207 = 0;
                        $_vtype208 = 0;
                        $xfer += $input->readMapBegin($_ktype207, $_vtype208, $_size206);
                        for ($_i210 = 0; $_i210 < $_size206; ++$_i210) {
                            $key211 = '';
                            $val212 = '';
                            $xfer += $input->readString($key211);
                            $xfer += $input->readString($val212);
                            $this->attributes[$key211] = $val212;
                        }
                        $xfer += $input->readMapEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_getRows_args');
        if ($this->tableName !== null) {
            $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
            $xfer += $output->writeString($this->tableName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->rows !== null) {
            if (!is_array($this->rows)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('rows', TType::LST, 2);
            {
                $output->writeListBegin(TType::STRING, count($this->rows));
                {
                    foreach ($this->rows as $iter213) {
                        $xfer += $output->writeString($iter213);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->attributes !== null) {
            if (!is_array($this->attributes)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('attributes', TType::MAP, 3);
            {
                $output->writeMapBegin(TType::STRING, TType::STRING, count($this->attributes));
                {
                    foreach ($this->attributes as $kiter214 => $viter215) {
                        $xfer += $output->writeString($kiter214);
                        $xfer += $output->writeString($viter215);
                    }
                }
                $output->writeMapEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}