<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_getColumnDescriptors_result {
    static $_TSPEC;

    /**
     * @var array
     */
    public $success = null;
    /**
     * @var \Mainto\ThriftHbase\Hbase\IOError
     */
    public $io = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                0 => [
                    'var'   => 'success',
                    'type'  => TType::MAP,
                    'ktype' => TType::STRING,
                    'vtype' => TType::STRUCT,
                    'key'   => [
                        'type' => TType::STRING,
                    ],
                    'val'   => [
                        'type'  => TType::STRUCT,
                        'class' => '\Mainto\ThriftHbase\Hbase\ColumnDescriptor',
                    ],
                ],
                1 => [
                    'var'   => 'io',
                    'type'  => TType::STRUCT,
                    'class' => '\Mainto\ThriftHbase\Hbase\IOError',
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['success'])) {
                $this->success = $vals['success'];
            }
            if (isset($vals['io'])) {
                $this->io = $vals['io'];
            }
        }
    }

    public function getName () {
        return 'Hbase_getColumnDescriptors_result';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 0:
                    if ($ftype == TType::MAP) {
                        $this->success = [];
                        $_size51 = 0;
                        $_ktype52 = 0;
                        $_vtype53 = 0;
                        $xfer += $input->readMapBegin($_ktype52, $_vtype53, $_size51);
                        for ($_i55 = 0; $_i55 < $_size51; ++$_i55) {
                            $key56 = '';
                            $val57 = new \Mainto\ThriftHbase\Hbase\ColumnDescriptor();
                            $xfer += $input->readString($key56);
                            $val57 = new \Mainto\ThriftHbase\Hbase\ColumnDescriptor();
                            $xfer += $val57->read($input);
                            $this->success[$key56] = $val57;
                        }
                        $xfer += $input->readMapEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 1:
                    if ($ftype == TType::STRUCT) {
                        $this->io = new \Mainto\ThriftHbase\Hbase\IOError();
                        $xfer += $this->io->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_getColumnDescriptors_result');
        if ($this->success !== null) {
            if (!is_array($this->success)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
            {
                $output->writeMapBegin(TType::STRING, TType::STRUCT, count($this->success));
                {
                    foreach ($this->success as $kiter58 => $viter59) {
                        $xfer += $output->writeString($kiter58);
                        $xfer += $viter59->write($output);
                    }
                }
                $output->writeMapEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        if ($this->io !== null) {
            $xfer += $output->writeFieldBegin('io', TType::STRUCT, 1);
            $xfer += $this->io->write($output);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}