<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_createTable_args {
    static $_TSPEC;

    /**
     * name of table to create
     *
     * @var string
     */
    public $tableName = null;
    /**
     * list of column family descriptors
     *
     * @var \Mainto\ThriftHbase\Hbase\ColumnDescriptor[]
     */
    public $columnFamilies = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'tableName',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'   => 'columnFamilies',
                    'type'  => TType::LST,
                    'etype' => TType::STRUCT,
                    'elem'  => [
                        'type'  => TType::STRUCT,
                        'class' => '\Mainto\ThriftHbase\Hbase\ColumnDescriptor',
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['tableName'])) {
                $this->tableName = $vals['tableName'];
            }
            if (isset($vals['columnFamilies'])) {
                $this->columnFamilies = $vals['columnFamilies'];
            }
        }
    }

    public function getName () {
        return 'Hbase_createTable_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->tableName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::LST) {
                        $this->columnFamilies = [];
                        $_size67 = 0;
                        $_etype70 = 0;
                        $xfer += $input->readListBegin($_etype70, $_size67);
                        for ($_i71 = 0; $_i71 < $_size67; ++$_i71) {
                            $elem72 = null;
                            $elem72 = new \Mainto\ThriftHbase\Hbase\ColumnDescriptor();
                            $xfer += $elem72->read($input);
                            $this->columnFamilies [] = $elem72;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_createTable_args');
        if ($this->tableName !== null) {
            $xfer += $output->writeFieldBegin('tableName', TType::STRING, 1);
            $xfer += $output->writeString($this->tableName);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->columnFamilies !== null) {
            if (!is_array($this->columnFamilies)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('columnFamilies', TType::LST, 2);
            {
                $output->writeListBegin(TType::STRUCT, count($this->columnFamilies));
                {
                    foreach ($this->columnFamilies as $iter73) {
                        $xfer += $iter73->write($output);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}