<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_compact_args {
    static $_TSPEC;

    /**
     * @var string
     */
    public $tableNameOrRegionName = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'tableNameOrRegionName',
                    'type' => TType::STRING,
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['tableNameOrRegionName'])) {
                $this->tableNameOrRegionName = $vals['tableNameOrRegionName'];
            }
        }
    }

    public function getName () {
        return 'Hbase_compact_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->tableNameOrRegionName);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_compact_args');
        if ($this->tableNameOrRegionName !== null) {
            $xfer += $output->writeFieldBegin('tableNameOrRegionName', TType::STRING, 1);
            $xfer += $output->writeString($this->tableNameOrRegionName);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}