<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

class Hbase_append_args {
    static $_TSPEC;

    /**
     * The single append operation to apply
     *
     * @var \Mainto\ThriftHbase\Hbase\TAppend
     */
    public $append = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'   => 'append',
                    'type'  => TType::STRUCT,
                    'class' => '\Mainto\ThriftHbase\Hbase\TAppend',
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['append'])) {
                $this->append = $vals['append'];
            }
        }
    }

    public function getName () {
        return 'Hbase_append_args';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRUCT) {
                        $this->append = new \Mainto\ThriftHbase\Hbase\TAppend();
                        $xfer += $this->append->read($input);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('Hbase_append_args');
        if ($this->append !== null) {
            if (!is_object($this->append)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('append', TType::STRUCT, 1);
            $xfer += $this->append->write($output);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}