<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TApplicationException;
use Mainto\ThriftHbase\Thrift\Protocol\TBinaryProtocolAccelerated;
use Mainto\ThriftHbase\Thrift\Type\TMessageType;

class HbaseClient implements \Mainto\ThriftHbase\Hbase\HbaseIf {
    protected $input_ = null;
    protected $output_ = null;

    protected $seqid_ = 0;

    public function __construct ($input, $output = null) {
        $this->input_ = $input;
        $this->output_ = $output ? $output : $input;
    }

    public function enableTable ($tableName) {
        $this->send_enableTable($tableName);
        $this->recv_enableTable();
    }

    public function send_enableTable ($tableName) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_enableTable_args();
        $args->tableName = $tableName;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'enableTable', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('enableTable', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_enableTable () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_enableTable_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_enableTable_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function disableTable ($tableName) {
        $this->send_disableTable($tableName);
        $this->recv_disableTable();
    }

    public function send_disableTable ($tableName) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_disableTable_args();
        $args->tableName = $tableName;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'disableTable', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('disableTable', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_disableTable () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_disableTable_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_disableTable_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function isTableEnabled ($tableName) {
        $this->send_isTableEnabled($tableName);
        return $this->recv_isTableEnabled();
    }

    public function send_isTableEnabled ($tableName) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_isTableEnabled_args();
        $args->tableName = $tableName;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'isTableEnabled', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('isTableEnabled', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_isTableEnabled () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_isTableEnabled_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_isTableEnabled_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("isTableEnabled failed: unknown result");
    }

    public function compact ($tableNameOrRegionName) {
        $this->send_compact($tableNameOrRegionName);
        $this->recv_compact();
    }

    public function send_compact ($tableNameOrRegionName) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_compact_args();
        $args->tableNameOrRegionName = $tableNameOrRegionName;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'compact', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('compact', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_compact () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_compact_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_compact_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function majorCompact ($tableNameOrRegionName) {
        $this->send_majorCompact($tableNameOrRegionName);
        $this->recv_majorCompact();
    }

    public function send_majorCompact ($tableNameOrRegionName) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_majorCompact_args();
        $args->tableNameOrRegionName = $tableNameOrRegionName;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'majorCompact', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('majorCompact', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_majorCompact () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_majorCompact_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_majorCompact_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function getTableNames () {
        $this->send_getTableNames();
        return $this->recv_getTableNames();
    }

    public function send_getTableNames () {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getTableNames_args();
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getTableNames', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getTableNames', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getTableNames () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getTableNames_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getTableNames_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getTableNames failed: unknown result");
    }

    public function getColumnDescriptors ($tableName) {
        $this->send_getColumnDescriptors($tableName);
        return $this->recv_getColumnDescriptors();
    }

    public function send_getColumnDescriptors ($tableName) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getColumnDescriptors_args();
        $args->tableName = $tableName;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getColumnDescriptors', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getColumnDescriptors', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getColumnDescriptors () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getColumnDescriptors_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getColumnDescriptors_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getColumnDescriptors failed: unknown result");
    }

    public function getTableRegions ($tableName) {
        $this->send_getTableRegions($tableName);
        return $this->recv_getTableRegions();
    }

    public function send_getTableRegions ($tableName) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getTableRegions_args();
        $args->tableName = $tableName;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getTableRegions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getTableRegions', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getTableRegions () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getTableRegions_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getTableRegions_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getTableRegions failed: unknown result");
    }

    public function createTable ($tableName, array $columnFamilies) {
        $this->send_createTable($tableName, $columnFamilies);
        $this->recv_createTable();
    }

    public function send_createTable ($tableName, array $columnFamilies) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_createTable_args();
        $args->tableName = $tableName;
        $args->columnFamilies = $columnFamilies;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'createTable', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('createTable', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_createTable () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_createTable_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_createTable_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        if ($result->exist !== null) {
            throw $result->exist;
        }
        return;
    }

    public function deleteTable ($tableName) {
        $this->send_deleteTable($tableName);
        $this->recv_deleteTable();
    }

    public function send_deleteTable ($tableName) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_deleteTable_args();
        $args->tableName = $tableName;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'deleteTable', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('deleteTable', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_deleteTable () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_deleteTable_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_deleteTable_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function get ($tableName, $row, $column, array $attributes) {
        $this->send_get($tableName, $row, $column, $attributes);
        return $this->recv_get();
    }

    public function send_get ($tableName, $row, $column, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_get_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->column = $column;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'get', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('get', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_get () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_get_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_get_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("get failed: unknown result");
    }

    public function getVer ($tableName, $row, $column, $numVersions, array $attributes) {
        $this->send_getVer($tableName, $row, $column, $numVersions, $attributes);
        return $this->recv_getVer();
    }

    public function send_getVer ($tableName, $row, $column, $numVersions, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getVer_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->column = $column;
        $args->numVersions = $numVersions;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getVer', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getVer', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getVer () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getVer_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getVer_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getVer failed: unknown result");
    }

    public function getVerTs ($tableName, $row, $column, $timestamp, $numVersions, array $attributes) {
        $this->send_getVerTs($tableName, $row, $column, $timestamp, $numVersions, $attributes);
        return $this->recv_getVerTs();
    }

    public function send_getVerTs ($tableName, $row, $column, $timestamp, $numVersions, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getVerTs_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->column = $column;
        $args->timestamp = $timestamp;
        $args->numVersions = $numVersions;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getVerTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getVerTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getVerTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getVerTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getVerTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getVerTs failed: unknown result");
    }

    public function getRow ($tableName, $row, array $attributes) {
        $this->send_getRow($tableName, $row, $attributes);
        return $this->recv_getRow();
    }

    public function send_getRow ($tableName, $row, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRow_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRow', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRow () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRow_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRow_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRow failed: unknown result");
    }

    public function getRowWithColumns ($tableName, $row, array $columns, array $attributes) {
        $this->send_getRowWithColumns($tableName, $row, $columns, $attributes);
        return $this->recv_getRowWithColumns();
    }

    public function send_getRowWithColumns ($tableName, $row, array $columns, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRowWithColumns_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->columns = $columns;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRowWithColumns', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRowWithColumns', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRowWithColumns () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRowWithColumns_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRowWithColumns_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRowWithColumns failed: unknown result");
    }

    public function getRowTs ($tableName, $row, $timestamp, array $attributes) {
        $this->send_getRowTs($tableName, $row, $timestamp, $attributes);
        return $this->recv_getRowTs();
    }

    public function send_getRowTs ($tableName, $row, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRowTs_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRowTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRowTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRowTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRowTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRowTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRowTs failed: unknown result");
    }

    public function getRowWithColumnsTs ($tableName, $row, array $columns, $timestamp, array $attributes) {
        $this->send_getRowWithColumnsTs($tableName, $row, $columns, $timestamp, $attributes);
        return $this->recv_getRowWithColumnsTs();
    }

    public function send_getRowWithColumnsTs ($tableName, $row, array $columns, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRowWithColumnsTs_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->columns = $columns;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRowWithColumnsTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRowWithColumnsTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRowWithColumnsTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRowWithColumnsTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRowWithColumnsTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRowWithColumnsTs failed: unknown result");
    }

    public function getRows ($tableName, array $rows, array $attributes) {
        $this->send_getRows($tableName, $rows, $attributes);
        return $this->recv_getRows();
    }

    public function send_getRows ($tableName, array $rows, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRows_args();
        $args->tableName = $tableName;
        $args->rows = $rows;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRows', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRows', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRows () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRows_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRows_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRows failed: unknown result");
    }

    public function getRowsWithColumns ($tableName, array $rows, array $columns, array $attributes) {
        $this->send_getRowsWithColumns($tableName, $rows, $columns, $attributes);
        return $this->recv_getRowsWithColumns();
    }

    public function send_getRowsWithColumns ($tableName, array $rows, array $columns, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRowsWithColumns_args();
        $args->tableName = $tableName;
        $args->rows = $rows;
        $args->columns = $columns;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRowsWithColumns', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRowsWithColumns', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRowsWithColumns () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRowsWithColumns_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRowsWithColumns_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRowsWithColumns failed: unknown result");
    }

    public function getRowsTs ($tableName, array $rows, $timestamp, array $attributes) {
        $this->send_getRowsTs($tableName, $rows, $timestamp, $attributes);
        return $this->recv_getRowsTs();
    }

    public function send_getRowsTs ($tableName, array $rows, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRowsTs_args();
        $args->tableName = $tableName;
        $args->rows = $rows;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRowsTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRowsTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRowsTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRowsTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRowsTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRowsTs failed: unknown result");
    }

    public function getRowsWithColumnsTs ($tableName, array $rows, array $columns, $timestamp, array $attributes) {
        $this->send_getRowsWithColumnsTs($tableName, $rows, $columns, $timestamp, $attributes);
        return $this->recv_getRowsWithColumnsTs();
    }

    public function send_getRowsWithColumnsTs ($tableName, array $rows, array $columns, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRowsWithColumnsTs_args();
        $args->tableName = $tableName;
        $args->rows = $rows;
        $args->columns = $columns;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRowsWithColumnsTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRowsWithColumnsTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRowsWithColumnsTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRowsWithColumnsTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRowsWithColumnsTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRowsWithColumnsTs failed: unknown result");
    }

    public function mutateRow ($tableName, $row, array $mutations, array $attributes) {
        $this->send_mutateRow($tableName, $row, $mutations, $attributes);
        $this->recv_mutateRow();
    }

    public function send_mutateRow ($tableName, $row, array $mutations, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_mutateRow_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->mutations = $mutations;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'mutateRow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('mutateRow', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_mutateRow () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_mutateRow_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_mutateRow_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        return;
    }

    public function mutateRowTs ($tableName, $row, array $mutations, $timestamp, array $attributes) {
        $this->send_mutateRowTs($tableName, $row, $mutations, $timestamp, $attributes);
        $this->recv_mutateRowTs();
    }

    public function send_mutateRowTs ($tableName, $row, array $mutations, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_mutateRowTs_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->mutations = $mutations;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'mutateRowTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('mutateRowTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_mutateRowTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_mutateRowTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_mutateRowTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        return;
    }

    public function mutateRows ($tableName, array $rowBatches, array $attributes) {
        $this->send_mutateRows($tableName, $rowBatches, $attributes);
        $this->recv_mutateRows();
    }

    public function send_mutateRows ($tableName, array $rowBatches, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_mutateRows_args();
        $args->tableName = $tableName;
        $args->rowBatches = $rowBatches;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'mutateRows', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('mutateRows', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_mutateRows () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_mutateRows_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_mutateRows_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        return;
    }

    public function mutateRowsTs ($tableName, array $rowBatches, $timestamp, array $attributes) {
        $this->send_mutateRowsTs($tableName, $rowBatches, $timestamp, $attributes);
        $this->recv_mutateRowsTs();
    }

    public function send_mutateRowsTs ($tableName, array $rowBatches, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_mutateRowsTs_args();
        $args->tableName = $tableName;
        $args->rowBatches = $rowBatches;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'mutateRowsTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('mutateRowsTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_mutateRowsTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_mutateRowsTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_mutateRowsTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        return;
    }

    public function atomicIncrement ($tableName, $row, $column, $value) {
        $this->send_atomicIncrement($tableName, $row, $column, $value);
        return $this->recv_atomicIncrement();
    }

    public function send_atomicIncrement ($tableName, $row, $column, $value) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_atomicIncrement_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->column = $column;
        $args->value = $value;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'atomicIncrement', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('atomicIncrement', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_atomicIncrement () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_atomicIncrement_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_atomicIncrement_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        throw new \Exception("atomicIncrement failed: unknown result");
    }

    public function deleteAll ($tableName, $row, $column, array $attributes) {
        $this->send_deleteAll($tableName, $row, $column, $attributes);
        $this->recv_deleteAll();
    }

    public function send_deleteAll ($tableName, $row, $column, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_deleteAll_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->column = $column;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'deleteAll', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('deleteAll', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_deleteAll () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_deleteAll_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_deleteAll_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function deleteAllTs ($tableName, $row, $column, $timestamp, array $attributes) {
        $this->send_deleteAllTs($tableName, $row, $column, $timestamp, $attributes);
        $this->recv_deleteAllTs();
    }

    public function send_deleteAllTs ($tableName, $row, $column, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_deleteAllTs_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->column = $column;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'deleteAllTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('deleteAllTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_deleteAllTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_deleteAllTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_deleteAllTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function deleteAllRow ($tableName, $row, array $attributes) {
        $this->send_deleteAllRow($tableName, $row, $attributes);
        $this->recv_deleteAllRow();
    }

    public function send_deleteAllRow ($tableName, $row, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_deleteAllRow_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'deleteAllRow', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('deleteAllRow', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_deleteAllRow () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_deleteAllRow_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_deleteAllRow_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function increment (\Mainto\ThriftHbase\Hbase\TIncrement $increment) {
        $this->send_increment($increment);
        $this->recv_increment();
    }

    public function send_increment (\Mainto\ThriftHbase\Hbase\TIncrement $increment) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_increment_args();
        $args->increment = $increment;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'increment', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('increment', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_increment () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_increment_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_increment_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function incrementRows (array $increments) {
        $this->send_incrementRows($increments);
        $this->recv_incrementRows();
    }

    public function send_incrementRows (array $increments) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_incrementRows_args();
        $args->increments = $increments;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'incrementRows', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('incrementRows', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_incrementRows () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_incrementRows_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_incrementRows_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function deleteAllRowTs ($tableName, $row, $timestamp, array $attributes) {
        $this->send_deleteAllRowTs($tableName, $row, $timestamp, $attributes);
        $this->recv_deleteAllRowTs();
    }

    public function send_deleteAllRowTs ($tableName, $row, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_deleteAllRowTs_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'deleteAllRowTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('deleteAllRowTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_deleteAllRowTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_deleteAllRowTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_deleteAllRowTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        return;
    }

    public function scannerOpenWithScan ($tableName, \Mainto\ThriftHbase\Hbase\TScan $scan, array $attributes) {
        $this->send_scannerOpenWithScan($tableName, $scan, $attributes);
        return $this->recv_scannerOpenWithScan();
    }

    public function send_scannerOpenWithScan ($tableName, \Mainto\ThriftHbase\Hbase\TScan $scan, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithScan_args();
        $args->tableName = $tableName;
        $args->scan = $scan;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'scannerOpenWithScan', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('scannerOpenWithScan', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_scannerOpenWithScan () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithScan_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithScan_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("scannerOpenWithScan failed: unknown result");
    }

    public function scannerOpen ($tableName, $startRow, array $columns, array $attributes) {
        $this->send_scannerOpen($tableName, $startRow, $columns, $attributes);
        return $this->recv_scannerOpen();
    }

    public function send_scannerOpen ($tableName, $startRow, array $columns, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpen_args();
        $args->tableName = $tableName;
        $args->startRow = $startRow;
        $args->columns = $columns;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'scannerOpen', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('scannerOpen', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_scannerOpen () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_scannerOpen_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpen_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("scannerOpen failed: unknown result");
    }

    public function scannerOpenWithStop ($tableName, $startRow, $stopRow, array $columns, array $attributes) {
        $this->send_scannerOpenWithStop($tableName, $startRow, $stopRow, $columns, $attributes);
        return $this->recv_scannerOpenWithStop();
    }

    public function send_scannerOpenWithStop ($tableName, $startRow, $stopRow, array $columns, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithStop_args();
        $args->tableName = $tableName;
        $args->startRow = $startRow;
        $args->stopRow = $stopRow;
        $args->columns = $columns;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'scannerOpenWithStop', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('scannerOpenWithStop', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_scannerOpenWithStop () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithStop_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithStop_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("scannerOpenWithStop failed: unknown result");
    }

    public function scannerOpenWithPrefix ($tableName, $startAndPrefix, array $columns, array $attributes) {
        $this->send_scannerOpenWithPrefix($tableName, $startAndPrefix, $columns, $attributes);
        return $this->recv_scannerOpenWithPrefix();
    }

    public function send_scannerOpenWithPrefix ($tableName, $startAndPrefix, array $columns, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithPrefix_args();
        $args->tableName = $tableName;
        $args->startAndPrefix = $startAndPrefix;
        $args->columns = $columns;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'scannerOpenWithPrefix', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('scannerOpenWithPrefix', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_scannerOpenWithPrefix () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithPrefix_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithPrefix_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("scannerOpenWithPrefix failed: unknown result");
    }

    public function scannerOpenTs ($tableName, $startRow, array $columns, $timestamp, array $attributes) {
        $this->send_scannerOpenTs($tableName, $startRow, $columns, $timestamp, $attributes);
        return $this->recv_scannerOpenTs();
    }

    public function send_scannerOpenTs ($tableName, $startRow, array $columns, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenTs_args();
        $args->tableName = $tableName;
        $args->startRow = $startRow;
        $args->columns = $columns;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'scannerOpenTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('scannerOpenTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_scannerOpenTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_scannerOpenTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("scannerOpenTs failed: unknown result");
    }

    public function scannerOpenWithStopTs ($tableName, $startRow, $stopRow, array $columns, $timestamp, array $attributes) {
        $this->send_scannerOpenWithStopTs($tableName, $startRow, $stopRow, $columns, $timestamp, $attributes);
        return $this->recv_scannerOpenWithStopTs();
    }

    public function send_scannerOpenWithStopTs ($tableName, $startRow, $stopRow, array $columns, $timestamp, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithStopTs_args();
        $args->tableName = $tableName;
        $args->startRow = $startRow;
        $args->stopRow = $stopRow;
        $args->columns = $columns;
        $args->timestamp = $timestamp;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'scannerOpenWithStopTs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('scannerOpenWithStopTs', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_scannerOpenWithStopTs () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithStopTs_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_scannerOpenWithStopTs_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("scannerOpenWithStopTs failed: unknown result");
    }

    public function scannerGet ($id) {
        $this->send_scannerGet($id);
        return $this->recv_scannerGet();
    }

    public function send_scannerGet ($id) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_scannerGet_args();
        $args->id = $id;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'scannerGet', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('scannerGet', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_scannerGet () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_scannerGet_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_scannerGet_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        throw new \Exception("scannerGet failed: unknown result");
    }

    public function scannerGetList ($id, $nbRows) {
        $this->send_scannerGetList($id, $nbRows);
        return $this->recv_scannerGetList();
    }

    public function send_scannerGetList ($id, $nbRows) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_scannerGetList_args();
        $args->id = $id;
        $args->nbRows = $nbRows;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'scannerGetList', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('scannerGetList', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_scannerGetList () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_scannerGetList_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_scannerGetList_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        throw new \Exception("scannerGetList failed: unknown result");
    }

    public function scannerClose ($id) {
        $this->send_scannerClose($id);
        $this->recv_scannerClose();
    }

    public function send_scannerClose ($id) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_scannerClose_args();
        $args->id = $id;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'scannerClose', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('scannerClose', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_scannerClose () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_scannerClose_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_scannerClose_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        return;
    }

    public function getRowOrBefore ($tableName, $row, $family) {
        $this->send_getRowOrBefore($tableName, $row, $family);
        return $this->recv_getRowOrBefore();
    }

    public function send_getRowOrBefore ($tableName, $row, $family) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRowOrBefore_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->family = $family;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRowOrBefore', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRowOrBefore', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRowOrBefore () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRowOrBefore_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRowOrBefore_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRowOrBefore failed: unknown result");
    }

    public function getRegionInfo ($row) {
        $this->send_getRegionInfo($row);
        return $this->recv_getRegionInfo();
    }

    public function send_getRegionInfo ($row) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_getRegionInfo_args();
        $args->row = $row;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'getRegionInfo', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('getRegionInfo', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_getRegionInfo () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_getRegionInfo_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_getRegionInfo_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("getRegionInfo failed: unknown result");
    }

    public function append (\Mainto\ThriftHbase\Hbase\TAppend $append) {
        $this->send_append($append);
        return $this->recv_append();
    }

    public function send_append (\Mainto\ThriftHbase\Hbase\TAppend $append) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_append_args();
        $args->append = $append;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'append', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('append', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_append () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_append_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_append_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        throw new \Exception("append failed: unknown result");
    }

    public function checkAndPut ($tableName, $row, $column, $value, \Mainto\ThriftHbase\Hbase\Mutation $mput, array $attributes) {
        $this->send_checkAndPut($tableName, $row, $column, $value, $mput, $attributes);
        return $this->recv_checkAndPut();
    }

    public function send_checkAndPut ($tableName, $row, $column, $value, \Mainto\ThriftHbase\Hbase\Mutation $mput, array $attributes) {
        $args = new \Mainto\ThriftHbase\Hbase\Hbase_checkAndPut_args();
        $args->tableName = $tableName;
        $args->row = $row;
        $args->column = $column;
        $args->value = $value;
        $args->mput = $mput;
        $args->attributes = $attributes;
        $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
        if ($bin_accel) {
            thrift_protocol_write_binary($this->output_, 'checkAndPut', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
        } else {
            $this->output_->writeMessageBegin('checkAndPut', TMessageType::CALL, $this->seqid_);
            $args->write($this->output_);
            $this->output_->writeMessageEnd();
            $this->output_->getTransport()->flush();
        }
    }

    public function recv_checkAndPut () {
        $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
        if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Mainto\ThriftHbase\Hbase\Hbase_checkAndPut_result', $this->input_->isStrictRead());
        else {
            $rseqid = 0;
            $fname = null;
            $mtype = 0;

            $this->input_->readMessageBegin($fname, $mtype, $rseqid);
            if ($mtype == TMessageType::EXCEPTION) {
                $x = new TApplicationException();
                $x->read($this->input_);
                $this->input_->readMessageEnd();
                throw $x;
            }
            $result = new \Mainto\ThriftHbase\Hbase\Hbase_checkAndPut_result();
            $result->read($this->input_);
            $this->input_->readMessageEnd();
        }
        if ($result->success !== null) {
            return $result->success;
        }
        if ($result->io !== null) {
            throw $result->io;
        }
        if ($result->ia !== null) {
            throw $result->ia;
        }
        throw new \Exception("checkAndPut failed: unknown result");
    }

}