<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Type\TType;

/**
 * An HColumnDescriptor contains information about a column family
 * such as the number of versions, compression settings, etc. It is
 * used as input when creating a table or adding a column.
 */
class ColumnDescriptor {
    static $_TSPEC;

    /**
     * @var string
     */
    public $name = null;
    /**
     * @var int
     */
    public $maxVersions = 3;
    /**
     * @var string
     */
    public $compression = "NONE";
    /**
     * @var bool
     */
    public $inMemory = false;
    /**
     * @var string
     */
    public $bloomFilterType = "NONE";
    /**
     * @var int
     */
    public $bloomFilterVectorSize = 0;
    /**
     * @var int
     */
    public $bloomFilterNbHashes = 0;
    /**
     * @var bool
     */
    public $blockCacheEnabled = false;
    /**
     * @var int
     */
    public $timeToLive = 2147483647;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'name',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'  => 'maxVersions',
                    'type' => TType::I32,
                ],
                3 => [
                    'var'  => 'compression',
                    'type' => TType::STRING,
                ],
                4 => [
                    'var'  => 'inMemory',
                    'type' => TType::BOOL,
                ],
                5 => [
                    'var'  => 'bloomFilterType',
                    'type' => TType::STRING,
                ],
                6 => [
                    'var'  => 'bloomFilterVectorSize',
                    'type' => TType::I32,
                ],
                7 => [
                    'var'  => 'bloomFilterNbHashes',
                    'type' => TType::I32,
                ],
                8 => [
                    'var'  => 'blockCacheEnabled',
                    'type' => TType::BOOL,
                ],
                9 => [
                    'var'  => 'timeToLive',
                    'type' => TType::I32,
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['name'])) {
                $this->name = $vals['name'];
            }
            if (isset($vals['maxVersions'])) {
                $this->maxVersions = $vals['maxVersions'];
            }
            if (isset($vals['compression'])) {
                $this->compression = $vals['compression'];
            }
            if (isset($vals['inMemory'])) {
                $this->inMemory = $vals['inMemory'];
            }
            if (isset($vals['bloomFilterType'])) {
                $this->bloomFilterType = $vals['bloomFilterType'];
            }
            if (isset($vals['bloomFilterVectorSize'])) {
                $this->bloomFilterVectorSize = $vals['bloomFilterVectorSize'];
            }
            if (isset($vals['bloomFilterNbHashes'])) {
                $this->bloomFilterNbHashes = $vals['bloomFilterNbHashes'];
            }
            if (isset($vals['blockCacheEnabled'])) {
                $this->blockCacheEnabled = $vals['blockCacheEnabled'];
            }
            if (isset($vals['timeToLive'])) {
                $this->timeToLive = $vals['timeToLive'];
            }
        }
    }

    public function getName () {
        return 'ColumnDescriptor';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->name);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->maxVersions);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 3:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->compression);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 4:
                    if ($ftype == TType::BOOL) {
                        $xfer += $input->readBool($this->inMemory);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 5:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->bloomFilterType);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 6:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->bloomFilterVectorSize);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 7:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->bloomFilterNbHashes);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 8:
                    if ($ftype == TType::BOOL) {
                        $xfer += $input->readBool($this->blockCacheEnabled);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 9:
                    if ($ftype == TType::I32) {
                        $xfer += $input->readI32($this->timeToLive);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('ColumnDescriptor');
        if ($this->name !== null) {
            $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
            $xfer += $output->writeString($this->name);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->maxVersions !== null) {
            $xfer += $output->writeFieldBegin('maxVersions', TType::I32, 2);
            $xfer += $output->writeI32($this->maxVersions);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->compression !== null) {
            $xfer += $output->writeFieldBegin('compression', TType::STRING, 3);
            $xfer += $output->writeString($this->compression);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->inMemory !== null) {
            $xfer += $output->writeFieldBegin('inMemory', TType::BOOL, 4);
            $xfer += $output->writeBool($this->inMemory);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->bloomFilterType !== null) {
            $xfer += $output->writeFieldBegin('bloomFilterType', TType::STRING, 5);
            $xfer += $output->writeString($this->bloomFilterType);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->bloomFilterVectorSize !== null) {
            $xfer += $output->writeFieldBegin('bloomFilterVectorSize', TType::I32, 6);
            $xfer += $output->writeI32($this->bloomFilterVectorSize);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->bloomFilterNbHashes !== null) {
            $xfer += $output->writeFieldBegin('bloomFilterNbHashes', TType::I32, 7);
            $xfer += $output->writeI32($this->bloomFilterNbHashes);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->blockCacheEnabled !== null) {
            $xfer += $output->writeFieldBegin('blockCacheEnabled', TType::BOOL, 8);
            $xfer += $output->writeBool($this->blockCacheEnabled);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->timeToLive !== null) {
            $xfer += $output->writeFieldBegin('timeToLive', TType::I32, 9);
            $xfer += $output->writeI32($this->timeToLive);
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}