<?php

namespace Mainto\ThriftHbase\Hbase;

use Mainto\ThriftHbase\Thrift\Exception\TProtocolException;
use Mainto\ThriftHbase\Thrift\Type\TType;

/**
 * A BatchMutation object is used to apply a number of Mutations to a single row.
 */
class BatchMutation {
    static $_TSPEC;

    /**
     * @var string
     */
    public $row = null;
    /**
     * @var \Mainto\ThriftHbase\Hbase\Mutation[]
     */
    public $mutations = null;

    public function __construct ($vals = null) {
        if (!isset(self::$_TSPEC)) {
            self::$_TSPEC = [
                1 => [
                    'var'  => 'row',
                    'type' => TType::STRING,
                ],
                2 => [
                    'var'   => 'mutations',
                    'type'  => TType::LST,
                    'etype' => TType::STRUCT,
                    'elem'  => [
                        'type'  => TType::STRUCT,
                        'class' => '\Mainto\ThriftHbase\Hbase\Mutation',
                    ],
                ],
            ];
        }
        if (is_array($vals)) {
            if (isset($vals['row'])) {
                $this->row = $vals['row'];
            }
            if (isset($vals['mutations'])) {
                $this->mutations = $vals['mutations'];
            }
        }
    }

    public function getName () {
        return 'BatchMutation';
    }

    public function read ($input) {
        $xfer = 0;
        $fname = null;
        $ftype = 0;
        $fid = 0;
        $xfer += $input->readStructBegin($fname);
        while (true) {
            $xfer += $input->readFieldBegin($fname, $ftype, $fid);
            if ($ftype == TType::STOP) {
                break;
            }
            switch ($fid) {
                case 1:
                    if ($ftype == TType::STRING) {
                        $xfer += $input->readString($this->row);
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                case 2:
                    if ($ftype == TType::LST) {
                        $this->mutations = [];
                        $_size0 = 0;
                        $_etype3 = 0;
                        $xfer += $input->readListBegin($_etype3, $_size0);
                        for ($_i4 = 0; $_i4 < $_size0; ++$_i4) {
                            $elem5 = null;
                            $elem5 = new \Mainto\ThriftHbase\Hbase\Mutation();
                            $xfer += $elem5->read($input);
                            $this->mutations [] = $elem5;
                        }
                        $xfer += $input->readListEnd();
                    } else {
                        $xfer += $input->skip($ftype);
                    }
                    break;
                default:
                    $xfer += $input->skip($ftype);
                    break;
            }
            $xfer += $input->readFieldEnd();
        }
        $xfer += $input->readStructEnd();
        return $xfer;
    }

    public function write ($output) {
        $xfer = 0;
        $xfer += $output->writeStructBegin('BatchMutation');
        if ($this->row !== null) {
            $xfer += $output->writeFieldBegin('row', TType::STRING, 1);
            $xfer += $output->writeString($this->row);
            $xfer += $output->writeFieldEnd();
        }
        if ($this->mutations !== null) {
            if (!is_array($this->mutations)) {
                throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
            }
            $xfer += $output->writeFieldBegin('mutations', TType::LST, 2);
            {
                $output->writeListBegin(TType::STRUCT, count($this->mutations));
                {
                    foreach ($this->mutations as $iter6) {
                        $xfer += $iter6->write($output);
                    }
                }
                $output->writeListEnd();
            }
            $xfer += $output->writeFieldEnd();
        }
        $xfer += $output->writeFieldStop();
        $xfer += $output->writeStructEnd();
        return $xfer;
    }

}