<?php

namespace Mainto\ThriftHbase\Providers;

use Illuminate\Support\ServiceProvider;

class ThriftHabseServiceProvider extends ServiceProvider {
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot () {
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register () {
        $this->mergeConfigFrom(
            __DIR__ . '/../config/hbase.php',
            'hbase'
        );
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/hbase.php'   => config_path('hbase.php'),
            ], 'hbase');
        }
    }
}