<?php


namespace Mainto\ThriftHbase;


use Hbase\HbaseClient;
use Mainto\ThriftHbase\Exceptions\RpcRuntimeException;
use Mainto\ThriftHbase\Traits\ColumnTrait;
use Thrift\Protocol\TBinaryProtocol;
use Thrift\Transport\TBufferedTransport;
use Thrift\Transport\TSocket;

class ThriftHbaseClient {

    use ColumnTrait;

    protected string $tableName;

    protected HbaseClient $client;

    function  __construct (string $tableName) {
        $socket = new TSocket(config('hbase.host'), config('hbase.port'));
        $socket->setSendTimeout(config('hbase.send_time_out'));
        $socket->setRecvTimeout(config('hbase.recv_time_out'));
        $transport = new TBufferedTransport($socket);
        $protocol = new TBinaryProtocol($transport);
        $this->client = new HbaseClient($protocol);
        $this->tableName = $tableName;
        $transport->open();

    }

    /**
     * @param string $rowKey
     * @param array $columns
     * @return bool
     */
    function put (string $rowKey, array $columns) {
        try {
            $this->client->mutateRow($this->tableName, $rowKey, $this->buildMutations($columns), []);
        }catch (\Exception $exception){
            throw new RpcRuntimeException($exception->getMessage(), 500);
        }
        return true;
    }

    function get(string $rowKey, string $column) {
        return $this->client->getRow($this->tableName, $rowKey, []);
    }

}