<?php

namespace Mainto\RpcServer\RpcUtil;

use Carbon\Carbon;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Symfony\Component\VarDumper\Caster\ReflectionCaster;
use Symfony\Component\VarDumper\Cloner\VarCloner;

class RpcVarUpload {
    private static ?RpcVarUpload $instance = null;
    private int $lastErrorTime = 0;

    public static function getInstance (): ?RpcVarUpload {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function upload ($var): string {
        if (hrtime(true) - $this->lastErrorTime < 60) {
            return "";
        }

        try {
            $cloner = new VarCloner();
            $cloner->addCasters(ReflectionCaster::UNSET_CLOSURE_FILE_INFO);
            $traceData = serialize($cloner->cloneVar($var));
            $name = Str::random(32);
            Http::withBody($traceData, 'text/serialize')
                ->timeout(5)
                ->post("http://rpc-var-collection.hzmantu.com/submit?randomName=$name");
            return $name;
        } catch (\Exception $e) {
            $this->lastErrorTime = hrtime(true);
            // nop
            return "";
        }
    }
}