<?php

namespace Mainto\RpcServer\RpcUtil\Tool;

use Mainto\RpcServer\RpcUtil\Tool\Monitor\Driver\Local;
use Mainto\RpcServer\RpcUtil\Tool\Monitor\Driver\SidecarPrometheus;
use Mainto\RpcServer\RpcUtil\Tool\Monitor\DriverInterface;
use RuntimeException;

/**
 * @deprecated
 */
class RpcMonitor implements RpcMonitorInterface {
    private static array $instance = [];
    protected static ?DriverInterface $driver = null;
    protected static array $driverMap = [
        'prometheus' => SidecarPrometheus::class,
        'local'      => Local::class,
    ];

    private string $name;

    /**
     * @var string[]
     */
    private array $labelNames;
    /**
     * @var string[]
     */
    private array $labelValues = [];

    private static array $actionMap = [
        'set'     => ['type' => 'gauge', 'action' => 'Set'],
        'add'     => ['type' => 'gauge', 'action' => 'Add'],
        'sub'     => ['type' => 'gauge', 'action' => 'Sub'],
        'inc'     => ['type' => 'gauge', 'action' => 'Inc'],
        'dec'     => ['type' => 'gauge', 'action' => 'Dec'],
        'summary' => ['type' => 'summary', 'action' => 'Observe'],
    ];


    /**
     * RpcMonitor constructor.
     * @param string $name
     * @param string[] $labelNames
     */
    public function __construct (string $name, array $labelNames = []) {
        $this->name = $name;
        $this->labelNames = $labelNames;
    }

    /**
     * get the log instance
     *
     * @param string $name
     * @param string[] $labelNames
     * @return RpcMonitor
     */
    public static function getInstance (string $name, array $labelNames = []): RpcMonitor {
        if (!isset(self::$instance[$name])) {
            if (!static::$driver) {
                $logDriver = config("rpc-server.sidecar.monitor.driver", "local");
                if (!isset(static::$driverMap[$logDriver])) {
                    throw new RuntimeException("can not find {$logDriver} monitor driver");
                }
                static::$driver = new static::$driverMap[$logDriver]();
            }

            self::$instance[$name] = new self($name, $labelNames);
        }
        return self::$instance[$name];
    }

    /**
     * clear cache instance
     */
    public static function clearDriver () {
        static::$driver = null;
    }

    private function dealParam (string $function, float $value = null): array {
        if (!self::$actionMap[$function]) throw new RuntimeException("actionMap not exist", 0);
        return [
            "type"         => data_get(self::$actionMap[$function], 'type'),
            "name"         => $this->name,
            "label_names"  => $this->labelNames,
            "label_values" => $this->labelValues,
            "content"      => [
                'action' => data_get(self::$actionMap[$function], 'action'),
                'value'  => $value,
            ],
        ];

    }

    /**
     * @param string ...$value
     * @return $this
     */
    public function withLabelValues (...$value): self {
        $this->labelValues = $value;

        return $this;
    }

    public function set (float $value) {
        static::$driver->send($this->dealParam(__FUNCTION__, $value));
    }

    public function add (float $value) {
        static::$driver->send($this->dealParam(__FUNCTION__, $value));
    }

    public function sub (float $value) {
        static::$driver->send($this->dealParam(__FUNCTION__, $value));
    }

    public function inc () {
        static::$driver->send($this->dealParam(__FUNCTION__));
    }

    public function dec () {
        static::$driver->send($this->dealParam(__FUNCTION__));
    }

    public function summary (float $value) {
        static::$driver->send($this->dealParam(__FUNCTION__, $value));
    }
}
