<?php

namespace Mainto\RpcServer\RpcServer\Middleware\Kernel;

use Closure;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\Middleware\KernelMiddleware;
use Mainto\RpcServer\RpcServer\RpcStreamContext;

class XhprofKernelMiddleware implements KernelMiddleware {

    private bool $enable;

    public function __construct () {
        $this->enable = env('RPC_ENABLE_PROF', false) === true;
    }

    public function handle (RpcStreamContext $context, Closure $next): Response {
        if (!$this->enable) {
            return $next($context);
        }
        xhprof_enable(XHPROF_FLAGS_CPU + XHPROF_FLAGS_MEMORY + XHPROF_FLAGS_NO_BUILTINS);
        $resp = $next($context);
        $data = xhprof_disable();
        $microTs = (int)(microtime(true) * 1000000); // 单位：微秒
        file_put_contents('/tmp/prof_'.$microTs, json_encode($data));
        return $resp;
    }
}