<?php

namespace Mainto\RpcServer\RpcUtil\Tool\RpcMutex;

use Mainto\RpcServer\Exceptions\RpcLockException;
use Mainto\RpcServer\RpcUtil\Tool\RpcMutexProviderInterface;

class FileMutex implements RpcMutexProviderInterface {
    public static array $locks = [];

    public static function getLock (string $lockName, int $expireTime = 600) {
        if (isset(static::$locks[$lockName])) {
            throw new RpcLockException("{$lockName} lock fail, try it later", 0xF0106801);
        } else {
            $fp = fopen('/tmp/mtrpc_mutex_'.$lockName, 'w+');
            if (!flock($fp, LOCK_EX)) {
                throw new RpcLockException("{$lockName} lock fail, try it later", 0xF0106801);
            }
            $password = rand(100000000000, 9999999999999999);
            fwrite($fp, $password);
            static::$locks[$lockName] = $fp;
            return $password;
        }
    }

    public static function unLock (string $lockName, string $password): bool {
        if (!isset(static::$locks[$lockName])) {
            return false;
        }
        $fp = static::$locks[$lockName];

        fseek($fp, 0);
        if (fread($fp, 1000) === $password) {
            flock($fp, LOCK_UN);
            fclose($fp);
            unlink('/tmp/mtrpc_mutex_'.$lockName);
            return true;
        }

        return false;
    }
}