<?php


namespace Mainto\RpcServer\Providers\SqlTrace;

use Closure;
use Mainto\RpcServer\RpcUtil\JsonHelper;
use Mainto\RpcServer\Tracing\Interfaces\AttributeKey;
use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Span;

class PostgresConnection extends \Illuminate\Database\PostgresConnection {
    public function run ($query, $bindings, Closure $callback) {
        $span = Span::start('Pgsql Connection::run', null, SpanKind::KIND_CLIENT);
        try {
            $span->setAttribute(AttributeKey::DBSystemKey, 'postgresql');
            $span->setAttribute(AttributeKey::DBNameKey, $this->getDatabaseName());
            $span->setAttribute(AttributeKey::DBUserKey, $this->getConfig('username'));
            if ($this->getPdo()->inTransaction()) {
                $span->setAttribute(AttributeKey::DBInTransaction, 'true');
            }
            $span->setAttribute(AttributeKey::DBStatementKey, $query);
            // 判断是否为空，不为空则记录
            if (!empty($bindings)) {
                $span->setAttribute(AttributeKey::DBBindings, JsonHelper::encodeWithUnescapedAndError($bindings));
            }
            return parent::run($query, $bindings, $callback);
        } finally {
            $span->end();
        }
    }
}
