<?php

namespace Mainto\RpcServer\Service\Struct;


use Illuminate\Contracts\Support\Arrayable;

class Message implements Arrayable {
    use BaseStruct;

    private string $messageHookName = "";

    /**
     * @var int
     */
    private int $dedicatedPoolSize = 0;

    /**
     * @param string $messageHookName
     */
    public function setMessageHookName (string $messageHookName): void {
        $this->messageHookName = $messageHookName;
    }

    public function setDedicatedPoolSize (int $dedicatedPoolSize): void {
        $this->dedicatedPoolSize = $dedicatedPoolSize;
    }

    public function isEmpty (): bool {
        return $this->messageHookName === "";
    }

    public function toArray () {
        return [
            'class'               => $this->class,
            'method'              => $this->method,
            'message_hook_name'   => $this->messageHookName,
            'dedicated_pool_size' => $this->dedicatedPoolSize,
        ];
    }
}